/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.osis.DefaultOsisBaseClientBuilder;
import software.amazon.awssdk.services.osis.DefaultOsisClient;
import software.amazon.awssdk.services.osis.OsisClient;
import software.amazon.awssdk.services.osis.OsisClientBuilder;
import software.amazon.awssdk.services.osis.OsisServiceClientConfiguration;
import software.amazon.awssdk.services.osis.endpoints.OsisEndpointProvider;

@SdkInternalApi
final class DefaultOsisClientBuilder
extends DefaultOsisBaseClientBuilder<OsisClientBuilder, OsisClient>
implements OsisClientBuilder {
    DefaultOsisClientBuilder() {
    }

    @Override
    public DefaultOsisClientBuilder endpointProvider(OsisEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OsisClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOsisClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        OsisServiceClientConfiguration serviceClientConfiguration = OsisServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultOsisClient(serviceClientConfiguration, clientConfiguration);
    }
}

