/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.osis.model.SubnetIdsCopier;
import software.amazon.awssdk.services.osis.model.VpcAttachmentOptions;
import software.amazon.awssdk.services.osis.model.VpcEndpointManagement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcOptions> {
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(VpcOptions.getter(VpcOptions::subnetIds)).setter(VpcOptions.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(VpcOptions.getter(VpcOptions::securityGroupIds)).setter(VpcOptions.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcAttachmentOptions> VPC_ATTACHMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcAttachmentOptions").getter(VpcOptions.getter(VpcOptions::vpcAttachmentOptions)).setter(VpcOptions.setter(Builder::vpcAttachmentOptions)).constructor(VpcAttachmentOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcAttachmentOptions").build()}).build();
    private static final SdkField<String> VPC_ENDPOINT_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointManagement").getter(VpcOptions.getter(VpcOptions::vpcEndpointManagementAsString)).setter(VpcOptions.setter(Builder::vpcEndpointManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointManagement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, VPC_ATTACHMENT_OPTIONS_FIELD, VPC_ENDPOINT_MANAGEMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final VpcAttachmentOptions vpcAttachmentOptions;
    private final String vpcEndpointManagement;

    private VpcOptions(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.vpcAttachmentOptions = builder.vpcAttachmentOptions;
        this.vpcEndpointManagement = builder.vpcEndpointManagement;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final VpcAttachmentOptions vpcAttachmentOptions() {
        return this.vpcAttachmentOptions;
    }

    public final VpcEndpointManagement vpcEndpointManagement() {
        return VpcEndpointManagement.fromValue(this.vpcEndpointManagement);
    }

    public final String vpcEndpointManagementAsString() {
        return this.vpcEndpointManagement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcAttachmentOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointManagementAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOptions)) {
            return false;
        }
        VpcOptions other = (VpcOptions)obj;
        return this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.vpcAttachmentOptions(), other.vpcAttachmentOptions()) && Objects.equals(this.vpcEndpointManagementAsString(), other.vpcEndpointManagementAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VpcOptions").add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("VpcAttachmentOptions", (Object)this.vpcAttachmentOptions()).add("VpcEndpointManagement", (Object)this.vpcEndpointManagementAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "VpcAttachmentOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcAttachmentOptions()));
            }
            case "VpcEndpointManagement": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointManagementAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcOptions, T> g) {
        return obj -> g.apply((VpcOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private VpcAttachmentOptions vpcAttachmentOptions;
        private String vpcEndpointManagement;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOptions model) {
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.vpcAttachmentOptions(model.vpcAttachmentOptions);
            this.vpcEndpointManagement(model.vpcEndpointManagement);
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final VpcAttachmentOptions.Builder getVpcAttachmentOptions() {
            return this.vpcAttachmentOptions != null ? this.vpcAttachmentOptions.toBuilder() : null;
        }

        public final void setVpcAttachmentOptions(VpcAttachmentOptions.BuilderImpl vpcAttachmentOptions) {
            this.vpcAttachmentOptions = vpcAttachmentOptions != null ? vpcAttachmentOptions.build() : null;
        }

        @Override
        public final Builder vpcAttachmentOptions(VpcAttachmentOptions vpcAttachmentOptions) {
            this.vpcAttachmentOptions = vpcAttachmentOptions;
            return this;
        }

        public final String getVpcEndpointManagement() {
            return this.vpcEndpointManagement;
        }

        public final void setVpcEndpointManagement(String vpcEndpointManagement) {
            this.vpcEndpointManagement = vpcEndpointManagement;
        }

        @Override
        public final Builder vpcEndpointManagement(String vpcEndpointManagement) {
            this.vpcEndpointManagement = vpcEndpointManagement;
            return this;
        }

        @Override
        public final Builder vpcEndpointManagement(VpcEndpointManagement vpcEndpointManagement) {
            this.vpcEndpointManagement(vpcEndpointManagement == null ? null : vpcEndpointManagement.toString());
            return this;
        }

        public VpcOptions build() {
            return new VpcOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcOptions> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder vpcAttachmentOptions(VpcAttachmentOptions var1);

        default public Builder vpcAttachmentOptions(Consumer<VpcAttachmentOptions.Builder> vpcAttachmentOptions) {
            return this.vpcAttachmentOptions((VpcAttachmentOptions)((VpcAttachmentOptions.Builder)VpcAttachmentOptions.builder().applyMutation(vpcAttachmentOptions)).build());
        }

        public Builder vpcEndpointManagement(String var1);

        public Builder vpcEndpointManagement(VpcEndpointManagement var1);
    }
}

