/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of an OpenSearch Ingestion blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineBlueprintSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineBlueprintSummary.Builder, PipelineBlueprintSummary> {
    private static final SdkField<String> BLUEPRINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueprintName").getter(getter(PipelineBlueprintSummary::blueprintName))
            .setter(setter(Builder::blueprintName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintName").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(PipelineBlueprintSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DISPLAY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayDescription").getter(getter(PipelineBlueprintSummary::displayDescription))
            .setter(setter(Builder::displayDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayDescription").build())
            .build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(PipelineBlueprintSummary::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<String> USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCase").getter(getter(PipelineBlueprintSummary::useCase)).setter(setter(Builder::useCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINT_NAME_FIELD,
            DISPLAY_NAME_FIELD, DISPLAY_DESCRIPTION_FIELD, SERVICE_FIELD, USE_CASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String blueprintName;

    private final String displayName;

    private final String displayDescription;

    private final String service;

    private final String useCase;

    private PipelineBlueprintSummary(BuilderImpl builder) {
        this.blueprintName = builder.blueprintName;
        this.displayName = builder.displayName;
        this.displayDescription = builder.displayDescription;
        this.service = builder.service;
        this.useCase = builder.useCase;
    }

    /**
     * <p>
     * The name of the blueprint.
     * </p>
     * 
     * @return The name of the blueprint.
     */
    public final String blueprintName() {
        return blueprintName;
    }

    /**
     * <p>
     * The display name of the blueprint.
     * </p>
     * 
     * @return The display name of the blueprint.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A description of the blueprint.
     * </p>
     * 
     * @return A description of the blueprint.
     */
    public final String displayDescription() {
        return displayDescription;
    }

    /**
     * <p>
     * The name of the service that the blueprint is associated with.
     * </p>
     * 
     * @return The name of the service that the blueprint is associated with.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The use case that the blueprint relates to.
     * </p>
     * 
     * @return The use case that the blueprint relates to.
     */
    public final String useCase() {
        return useCase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(displayDescription());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(useCase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineBlueprintSummary)) {
            return false;
        }
        PipelineBlueprintSummary other = (PipelineBlueprintSummary) obj;
        return Objects.equals(blueprintName(), other.blueprintName()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(displayDescription(), other.displayDescription()) && Objects.equals(service(), other.service())
                && Objects.equals(useCase(), other.useCase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineBlueprintSummary").add("BlueprintName", blueprintName())
                .add("DisplayName", displayName()).add("DisplayDescription", displayDescription()).add("Service", service())
                .add("UseCase", useCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueprintName":
            return Optional.ofNullable(clazz.cast(blueprintName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "DisplayDescription":
            return Optional.ofNullable(clazz.cast(displayDescription()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "UseCase":
            return Optional.ofNullable(clazz.cast(useCase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlueprintName", BLUEPRINT_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("DisplayDescription", DISPLAY_DESCRIPTION_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("UseCase", USE_CASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineBlueprintSummary, T> g) {
        return obj -> g.apply((PipelineBlueprintSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineBlueprintSummary> {
        /**
         * <p>
         * The name of the blueprint.
         * </p>
         * 
         * @param blueprintName
         *        The name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * <p>
         * The display name of the blueprint.
         * </p>
         * 
         * @param displayName
         *        The display name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A description of the blueprint.
         * </p>
         * 
         * @param displayDescription
         *        A description of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayDescription(String displayDescription);

        /**
         * <p>
         * The name of the service that the blueprint is associated with.
         * </p>
         * 
         * @param service
         *        The name of the service that the blueprint is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The use case that the blueprint relates to.
         * </p>
         * 
         * @param useCase
         *        The use case that the blueprint relates to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCase(String useCase);
    }

    static final class BuilderImpl implements Builder {
        private String blueprintName;

        private String displayName;

        private String displayDescription;

        private String service;

        private String useCase;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineBlueprintSummary model) {
            blueprintName(model.blueprintName);
            displayName(model.displayName);
            displayDescription(model.displayDescription);
            service(model.service);
            useCase(model.useCase);
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDisplayDescription() {
            return displayDescription;
        }

        public final void setDisplayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
        }

        @Override
        public final Builder displayDescription(String displayDescription) {
            this.displayDescription = displayDescription;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getUseCase() {
            return useCase;
        }

        public final void setUseCase(String useCase) {
            this.useCase = useCase;
        }

        @Override
        public final Builder useCase(String useCase) {
            this.useCase = useCase;
            return this;
        }

        @Override
        public PipelineBlueprintSummary build() {
            return new PipelineBlueprintSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
