/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for attaching a VPC to pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcAttachmentOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcAttachmentOptions.Builder, VpcAttachmentOptions> {
    private static final SdkField<Boolean> ATTACH_TO_VPC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AttachToVpc").getter(getter(VpcAttachmentOptions::attachToVpc)).setter(setter(Builder::attachToVpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachToVpc").build()).build();

    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CidrBlock").getter(getter(VpcAttachmentOptions::cidrBlock)).setter(setter(Builder::cidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TO_VPC_FIELD,
            CIDR_BLOCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean attachToVpc;

    private final String cidrBlock;

    private VpcAttachmentOptions(BuilderImpl builder) {
        this.attachToVpc = builder.attachToVpc;
        this.cidrBlock = builder.cidrBlock;
    }

    /**
     * <p>
     * Whether a VPC is attached to the pipeline.
     * </p>
     * 
     * @return Whether a VPC is attached to the pipeline.
     */
    public final Boolean attachToVpc() {
        return attachToVpc;
    }

    /**
     * <p>
     * The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
     * </p>
     * 
     * @return The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
     */
    public final String cidrBlock() {
        return cidrBlock;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachToVpc());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcAttachmentOptions)) {
            return false;
        }
        VpcAttachmentOptions other = (VpcAttachmentOptions) obj;
        return Objects.equals(attachToVpc(), other.attachToVpc()) && Objects.equals(cidrBlock(), other.cidrBlock());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcAttachmentOptions").add("AttachToVpc", attachToVpc()).add("CidrBlock", cidrBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachToVpc":
            return Optional.ofNullable(clazz.cast(attachToVpc()));
        case "CidrBlock":
            return Optional.ofNullable(clazz.cast(cidrBlock()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachToVpc", ATTACH_TO_VPC_FIELD);
        map.put("CidrBlock", CIDR_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcAttachmentOptions, T> g) {
        return obj -> g.apply((VpcAttachmentOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcAttachmentOptions> {
        /**
         * <p>
         * Whether a VPC is attached to the pipeline.
         * </p>
         * 
         * @param attachToVpc
         *        Whether a VPC is attached to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachToVpc(Boolean attachToVpc);

        /**
         * <p>
         * The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
         * </p>
         * 
         * @param cidrBlock
         *        The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);
    }

    static final class BuilderImpl implements Builder {
        private Boolean attachToVpc;

        private String cidrBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcAttachmentOptions model) {
            attachToVpc(model.attachToVpc);
            cidrBlock(model.cidrBlock);
        }

        public final Boolean getAttachToVpc() {
            return attachToVpc;
        }

        public final void setAttachToVpc(Boolean attachToVpc) {
            this.attachToVpc = attachToVpc;
        }

        @Override
        public final Builder attachToVpc(Boolean attachToVpc) {
            this.attachToVpc = attachToVpc;
            return this;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        @Override
        public VpcAttachmentOptions build() {
            return new VpcAttachmentOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
