/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options that specify the configuration of a persistent buffer. To configure how OpenSearch Ingestion encrypts this
 * data, set the <code>EncryptionAtRestOptions</code>. For more information, see <a href=
 * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering"
 * >Persistent buffering</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BufferOptions implements SdkPojo, Serializable, ToCopyableBuilder<BufferOptions.Builder, BufferOptions> {
    private static final SdkField<Boolean> PERSISTENT_BUFFER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PersistentBufferEnabled").getter(getter(BufferOptions::persistentBufferEnabled))
            .setter(setter(Builder::persistentBufferEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentBufferEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PERSISTENT_BUFFER_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean persistentBufferEnabled;

    private BufferOptions(BuilderImpl builder) {
        this.persistentBufferEnabled = builder.persistentBufferEnabled;
    }

    /**
     * <p>
     * Whether persistent buffering should be enabled.
     * </p>
     * 
     * @return Whether persistent buffering should be enabled.
     */
    public final Boolean persistentBufferEnabled() {
        return persistentBufferEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(persistentBufferEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BufferOptions)) {
            return false;
        }
        BufferOptions other = (BufferOptions) obj;
        return Objects.equals(persistentBufferEnabled(), other.persistentBufferEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BufferOptions").add("PersistentBufferEnabled", persistentBufferEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PersistentBufferEnabled":
            return Optional.ofNullable(clazz.cast(persistentBufferEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PersistentBufferEnabled", PERSISTENT_BUFFER_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BufferOptions, T> g) {
        return obj -> g.apply((BufferOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BufferOptions> {
        /**
         * <p>
         * Whether persistent buffering should be enabled.
         * </p>
         * 
         * @param persistentBufferEnabled
         *        Whether persistent buffering should be enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentBufferEnabled(Boolean persistentBufferEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean persistentBufferEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(BufferOptions model) {
            persistentBufferEnabled(model.persistentBufferEnabled);
        }

        public final Boolean getPersistentBufferEnabled() {
            return persistentBufferEnabled;
        }

        public final void setPersistentBufferEnabled(Boolean persistentBufferEnabled) {
            this.persistentBufferEnabled = persistentBufferEnabled;
        }

        @Override
        public final Builder persistentBufferEnabled(Boolean persistentBufferEnabled) {
            this.persistentBufferEnabled = persistentBufferEnabled;
            return this;
        }

        @Override
        public BufferOptions build() {
            return new BufferOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
