/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for information about VPC endpoints that were created to other services
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceVpcEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceVpcEndpoint.Builder, ServiceVpcEndpoint> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ServiceVpcEndpoint::serviceNameAsString))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(ServiceVpcEndpoint::vpcEndpointId)).setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            VPC_ENDPOINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final String vpcEndpointId;

    private ServiceVpcEndpoint(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.vpcEndpointId = builder.vpcEndpointId;
    }

    /**
     * <p>
     * The name of the service for which a VPC endpoint was created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link VpcEndpointServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the service for which a VPC endpoint was created.
     * @see VpcEndpointServiceName
     */
    public final VpcEndpointServiceName serviceName() {
        return VpcEndpointServiceName.fromValue(serviceName);
    }

    /**
     * <p>
     * The name of the service for which a VPC endpoint was created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceName} will
     * return {@link VpcEndpointServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNameAsString}.
     * </p>
     * 
     * @return The name of the service for which a VPC endpoint was created.
     * @see VpcEndpointServiceName
     */
    public final String serviceNameAsString() {
        return serviceName;
    }

    /**
     * <p>
     * The unique identifier of the VPC endpoint that was created.
     * </p>
     * 
     * @return The unique identifier of the VPC endpoint that was created.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceVpcEndpoint)) {
            return false;
        }
        ServiceVpcEndpoint other = (ServiceVpcEndpoint) obj;
        return Objects.equals(serviceNameAsString(), other.serviceNameAsString())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceVpcEndpoint").add("ServiceName", serviceNameAsString())
                .add("VpcEndpointId", vpcEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceNameAsString()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceVpcEndpoint, T> g) {
        return obj -> g.apply((ServiceVpcEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceVpcEndpoint> {
        /**
         * <p>
         * The name of the service for which a VPC endpoint was created.
         * </p>
         * 
         * @param serviceName
         *        The name of the service for which a VPC endpoint was created.
         * @see VpcEndpointServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointServiceName
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The name of the service for which a VPC endpoint was created.
         * </p>
         * 
         * @param serviceName
         *        The name of the service for which a VPC endpoint was created.
         * @see VpcEndpointServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcEndpointServiceName
         */
        Builder serviceName(VpcEndpointServiceName serviceName);

        /**
         * <p>
         * The unique identifier of the VPC endpoint that was created.
         * </p>
         * 
         * @param vpcEndpointId
         *        The unique identifier of the VPC endpoint that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private String vpcEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceVpcEndpoint model) {
            serviceName(model.serviceName);
            vpcEndpointId(model.vpcEndpointId);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(VpcEndpointServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        @Override
        public ServiceVpcEndpoint build() {
            return new ServiceVpcEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
