/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineRequest extends OsisRequest implements
        ToCopyableBuilder<UpdatePipelineRequest.Builder, UpdatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(UpdatePipelineRequest::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PipelineName").build()).build();

    private static final SdkField<Integer> MIN_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinUnits").getter(getter(UpdatePipelineRequest::minUnits)).setter(setter(Builder::minUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinUnits").build()).build();

    private static final SdkField<Integer> MAX_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxUnits").getter(getter(UpdatePipelineRequest::maxUnits)).setter(setter(Builder::maxUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUnits").build()).build();

    private static final SdkField<String> PIPELINE_CONFIGURATION_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineConfigurationBody").getter(getter(UpdatePipelineRequest::pipelineConfigurationBody))
            .setter(setter(Builder::pipelineConfigurationBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineConfigurationBody").build())
            .build();

    private static final SdkField<LogPublishingOptions> LOG_PUBLISHING_OPTIONS_FIELD = SdkField
            .<LogPublishingOptions> builder(MarshallingType.SDK_POJO).memberName("LogPublishingOptions")
            .getter(getter(UpdatePipelineRequest::logPublishingOptions)).setter(setter(Builder::logPublishingOptions))
            .constructor(LogPublishingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build())
            .build();

    private static final SdkField<BufferOptions> BUFFER_OPTIONS_FIELD = SdkField
            .<BufferOptions> builder(MarshallingType.SDK_POJO).memberName("BufferOptions")
            .getter(getter(UpdatePipelineRequest::bufferOptions)).setter(setter(Builder::bufferOptions))
            .constructor(BufferOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferOptions").build()).build();

    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<EncryptionAtRestOptions> builder(MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions")
            .getter(getter(UpdatePipelineRequest::encryptionAtRestOptions)).setter(setter(Builder::encryptionAtRestOptions))
            .constructor(EncryptionAtRestOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            MIN_UNITS_FIELD, MAX_UNITS_FIELD, PIPELINE_CONFIGURATION_BODY_FIELD, LOG_PUBLISHING_OPTIONS_FIELD,
            BUFFER_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String pipelineName;

    private final Integer minUnits;

    private final Integer maxUnits;

    private final String pipelineConfigurationBody;

    private final LogPublishingOptions logPublishingOptions;

    private final BufferOptions bufferOptions;

    private final EncryptionAtRestOptions encryptionAtRestOptions;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.minUnits = builder.minUnits;
        this.maxUnits = builder.maxUnits;
        this.pipelineConfigurationBody = builder.pipelineConfigurationBody;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.bufferOptions = builder.bufferOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
    }

    /**
     * <p>
     * The name of the pipeline to update.
     * </p>
     * 
     * @return The name of the pipeline to update.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     * </p>
     * 
     * @return The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    public final Integer minUnits() {
        return minUnits;
    }

    /**
     * <p>
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs)
     * </p>
     * 
     * @return The maximum pipeline capacity, in Ingestion Compute Units (ICUs)
     */
    public final Integer maxUnits() {
        return maxUnits;
    }

    /**
     * <p>
     * The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a
     * .yaml file. If you provide the configuration as a string, each new line must be escaped with <code>\n</code>.
     * </p>
     * 
     * @return The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or
     *         within a .yaml file. If you provide the configuration as a string, each new line must be escaped with
     *         <code>\n</code>.
     */
    public final String pipelineConfigurationBody() {
        return pipelineConfigurationBody;
    }

    /**
     * <p>
     * Key-value pairs to configure log publishing.
     * </p>
     * 
     * @return Key-value pairs to configure log publishing.
     */
    public final LogPublishingOptions logPublishingOptions() {
        return logPublishingOptions;
    }

    /**
     * <p>
     * Key-value pairs to configure persistent buffering for the pipeline.
     * </p>
     * 
     * @return Key-value pairs to configure persistent buffering for the pipeline.
     */
    public final BufferOptions bufferOptions() {
        return bufferOptions;
    }

    /**
     * <p>
     * Key-value pairs to configure encryption for data that is written to a persistent buffer.
     * </p>
     * 
     * @return Key-value pairs to configure encryption for data that is written to a persistent buffer.
     */
    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(minUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maxUnits());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineConfigurationBody());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(bufferOptions());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(minUnits(), other.minUnits())
                && Objects.equals(maxUnits(), other.maxUnits())
                && Objects.equals(pipelineConfigurationBody(), other.pipelineConfigurationBody())
                && Objects.equals(logPublishingOptions(), other.logPublishingOptions())
                && Objects.equals(bufferOptions(), other.bufferOptions())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipelineRequest").add("PipelineName", pipelineName()).add("MinUnits", minUnits())
                .add("MaxUnits", maxUnits()).add("PipelineConfigurationBody", pipelineConfigurationBody())
                .add("LogPublishingOptions", logPublishingOptions()).add("BufferOptions", bufferOptions())
                .add("EncryptionAtRestOptions", encryptionAtRestOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "MinUnits":
            return Optional.ofNullable(clazz.cast(minUnits()));
        case "MaxUnits":
            return Optional.ofNullable(clazz.cast(maxUnits()));
        case "PipelineConfigurationBody":
            return Optional.ofNullable(clazz.cast(pipelineConfigurationBody()));
        case "LogPublishingOptions":
            return Optional.ofNullable(clazz.cast(logPublishingOptions()));
        case "BufferOptions":
            return Optional.ofNullable(clazz.cast(bufferOptions()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineName", PIPELINE_NAME_FIELD);
        map.put("MinUnits", MIN_UNITS_FIELD);
        map.put("MaxUnits", MAX_UNITS_FIELD);
        map.put("PipelineConfigurationBody", PIPELINE_CONFIGURATION_BODY_FIELD);
        map.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
        map.put("BufferOptions", BUFFER_OPTIONS_FIELD);
        map.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OsisRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipelineRequest> {
        /**
         * <p>
         * The name of the pipeline to update.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
         * </p>
         * 
         * @param minUnits
         *        The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minUnits(Integer minUnits);

        /**
         * <p>
         * The maximum pipeline capacity, in Ingestion Compute Units (ICUs)
         * </p>
         * 
         * @param maxUnits
         *        The maximum pipeline capacity, in Ingestion Compute Units (ICUs)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUnits(Integer maxUnits);

        /**
         * <p>
         * The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or
         * within a .yaml file. If you provide the configuration as a string, each new line must be escaped with
         * <code>\n</code>.
         * </p>
         * 
         * @param pipelineConfigurationBody
         *        The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string
         *        or within a .yaml file. If you provide the configuration as a string, each new line must be escaped
         *        with <code>\n</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineConfigurationBody(String pipelineConfigurationBody);

        /**
         * <p>
         * Key-value pairs to configure log publishing.
         * </p>
         * 
         * @param logPublishingOptions
         *        Key-value pairs to configure log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptions(LogPublishingOptions logPublishingOptions);

        /**
         * <p>
         * Key-value pairs to configure log publishing.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogPublishingOptions.Builder} avoiding
         * the need to create one manually via {@link LogPublishingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogPublishingOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #logPublishingOptions(LogPublishingOptions)}.
         * 
         * @param logPublishingOptions
         *        a consumer that will call methods on {@link LogPublishingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingOptions(LogPublishingOptions)
         */
        default Builder logPublishingOptions(Consumer<LogPublishingOptions.Builder> logPublishingOptions) {
            return logPublishingOptions(LogPublishingOptions.builder().applyMutation(logPublishingOptions).build());
        }

        /**
         * <p>
         * Key-value pairs to configure persistent buffering for the pipeline.
         * </p>
         * 
         * @param bufferOptions
         *        Key-value pairs to configure persistent buffering for the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferOptions(BufferOptions bufferOptions);

        /**
         * <p>
         * Key-value pairs to configure persistent buffering for the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link BufferOptions.Builder} avoiding the need
         * to create one manually via {@link BufferOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BufferOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #bufferOptions(BufferOptions)}.
         * 
         * @param bufferOptions
         *        a consumer that will call methods on {@link BufferOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferOptions(BufferOptions)
         */
        default Builder bufferOptions(Consumer<BufferOptions.Builder> bufferOptions) {
            return bufferOptions(BufferOptions.builder().applyMutation(bufferOptions).build());
        }

        /**
         * <p>
         * Key-value pairs to configure encryption for data that is written to a persistent buffer.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        Key-value pairs to configure encryption for data that is written to a persistent buffer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions);

        /**
         * <p>
         * Key-value pairs to configure encryption for data that is written to a persistent buffer.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionAtRestOptions.Builder} avoiding
         * the need to create one manually via {@link EncryptionAtRestOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionAtRestOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionAtRestOptions(EncryptionAtRestOptions)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on {@link EncryptionAtRestOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(EncryptionAtRestOptions)
         */
        default Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OsisRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private Integer minUnits;

        private Integer maxUnits;

        private String pipelineConfigurationBody;

        private LogPublishingOptions logPublishingOptions;

        private BufferOptions bufferOptions;

        private EncryptionAtRestOptions encryptionAtRestOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            minUnits(model.minUnits);
            maxUnits(model.maxUnits);
            pipelineConfigurationBody(model.pipelineConfigurationBody);
            logPublishingOptions(model.logPublishingOptions);
            bufferOptions(model.bufferOptions);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final Integer getMinUnits() {
            return minUnits;
        }

        public final void setMinUnits(Integer minUnits) {
            this.minUnits = minUnits;
        }

        @Override
        public final Builder minUnits(Integer minUnits) {
            this.minUnits = minUnits;
            return this;
        }

        public final Integer getMaxUnits() {
            return maxUnits;
        }

        public final void setMaxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
        }

        @Override
        public final Builder maxUnits(Integer maxUnits) {
            this.maxUnits = maxUnits;
            return this;
        }

        public final String getPipelineConfigurationBody() {
            return pipelineConfigurationBody;
        }

        public final void setPipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
        }

        @Override
        public final Builder pipelineConfigurationBody(String pipelineConfigurationBody) {
            this.pipelineConfigurationBody = pipelineConfigurationBody;
            return this;
        }

        public final LogPublishingOptions.Builder getLogPublishingOptions() {
            return logPublishingOptions != null ? logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(LogPublishingOptions.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptions logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final BufferOptions.Builder getBufferOptions() {
            return bufferOptions != null ? bufferOptions.toBuilder() : null;
        }

        public final void setBufferOptions(BufferOptions.BuilderImpl bufferOptions) {
            this.bufferOptions = bufferOptions != null ? bufferOptions.build() : null;
        }

        @Override
        public final Builder bufferOptions(BufferOptions bufferOptions) {
            this.bufferOptions = bufferOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
