/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An OpenSearch Ingestion-managed VPC endpoint that will access one or more pipelines.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcEndpoint implements SdkPojo, Serializable, ToCopyableBuilder<VpcEndpoint.Builder, VpcEndpoint> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(VpcEndpoint::vpcEndpointId)).setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(VpcEndpoint::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<VpcOptions> VPC_OPTIONS_FIELD = SdkField.<VpcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOptions").getter(getter(VpcEndpoint::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(VpcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD,
            VPC_ID_FIELD, VPC_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcEndpointId;

    private final String vpcId;

    private final VpcOptions vpcOptions;

    private VpcEndpoint(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcId = builder.vpcId;
        this.vpcOptions = builder.vpcOptions;
    }

    /**
     * <p>
     * The unique identifier of the endpoint.
     * </p>
     * 
     * @return The unique identifier of the endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The ID for your VPC. Amazon Web Services PrivateLink generates this value when you create a VPC.
     * </p>
     * 
     * @return The ID for your VPC. Amazon Web Services PrivateLink generates this value when you create a VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Information about the VPC, including associated subnets and security groups.
     * </p>
     * 
     * @return Information about the VPC, including associated subnets and security groups.
     */
    public final VpcOptions vpcOptions() {
        return vpcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpoint)) {
            return false;
        }
        VpcEndpoint other = (VpcEndpoint) obj;
        return Objects.equals(vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(vpcOptions(), other.vpcOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcEndpoint").add("VpcEndpointId", vpcEndpointId()).add("VpcId", vpcId())
                .add("VpcOptions", vpcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "VpcOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpoint, T> g) {
        return obj -> g.apply((VpcEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcEndpoint> {
        /**
         * <p>
         * The unique identifier of the endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The unique identifier of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The ID for your VPC. Amazon Web Services PrivateLink generates this value when you create a VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID for your VPC. Amazon Web Services PrivateLink generates this value when you create a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Information about the VPC, including associated subnets and security groups.
         * </p>
         * 
         * @param vpcOptions
         *        Information about the VPC, including associated subnets and security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(VpcOptions vpcOptions);

        /**
         * <p>
         * Information about the VPC, including associated subnets and security groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOptions.Builder} avoiding the need to
         * create one manually via {@link VpcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcOptions(VpcOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link VpcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(VpcOptions)
         */
        default Builder vpcOptions(Consumer<VpcOptions.Builder> vpcOptions) {
            return vpcOptions(VpcOptions.builder().applyMutation(vpcOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String vpcEndpointId;

        private String vpcId;

        private VpcOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpoint model) {
            vpcEndpointId(model.vpcEndpointId);
            vpcId(model.vpcId);
            vpcOptions(model.vpcOptions);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final VpcOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VpcOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VpcOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        @Override
        public VpcEndpoint build() {
            return new VpcEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
