/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePipelineResponse extends OsisResponse implements
        ToCopyableBuilder<CreatePipelineResponse.Builder, CreatePipelineResponse> {
    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.<Pipeline> builder(MarshallingType.SDK_POJO)
            .memberName("Pipeline").getter(getter(CreatePipelineResponse::pipeline)).setter(setter(Builder::pipeline))
            .constructor(Pipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Pipeline pipeline;

    private CreatePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
    }

    /**
     * <p>
     * Container for information about the created pipeline.
     * </p>
     * 
     * @return Container for information about the created pipeline.
     */
    public final Pipeline pipeline() {
        return pipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineResponse)) {
            return false;
        }
        CreatePipelineResponse other = (CreatePipelineResponse) obj;
        return Objects.equals(pipeline(), other.pipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePipelineResponse").add("Pipeline", pipeline()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Pipeline", PIPELINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineResponse, T> g) {
        return obj -> g.apply((CreatePipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OsisResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePipelineResponse> {
        /**
         * <p>
         * Container for information about the created pipeline.
         * </p>
         * 
         * @param pipeline
         *        Container for information about the created pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(Pipeline pipeline);

        /**
         * <p>
         * Container for information about the created pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link Pipeline.Builder} avoiding the need to
         * create one manually via {@link Pipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Pipeline.Builder#build()} is called immediately and its result is
         * passed to {@link #pipeline(Pipeline)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link Pipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(Pipeline)
         */
        default Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return pipeline(Pipeline.builder().applyMutation(pipeline).build());
        }
    }

    static final class BuilderImpl extends OsisResponse.BuilderImpl implements Builder {
        private Pipeline pipeline;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineResponse model) {
            super(model);
            pipeline(model.pipeline);
        }

        public final Pipeline.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        @Override
        public CreatePipelineResponse build() {
            return new CreatePipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
