/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPipelineBlueprintResponse extends OsisResponse implements
        ToCopyableBuilder<GetPipelineBlueprintResponse.Builder, GetPipelineBlueprintResponse> {
    private static final SdkField<PipelineBlueprint> BLUEPRINT_FIELD = SdkField
            .<PipelineBlueprint> builder(MarshallingType.SDK_POJO).memberName("Blueprint")
            .getter(getter(GetPipelineBlueprintResponse::blueprint)).setter(setter(Builder::blueprint))
            .constructor(PipelineBlueprint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Blueprint").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetPipelineBlueprintResponse::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(BLUEPRINT_FIELD, FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PipelineBlueprint blueprint;

    private final String format;

    private GetPipelineBlueprintResponse(BuilderImpl builder) {
        super(builder);
        this.blueprint = builder.blueprint;
        this.format = builder.format;
    }

    /**
     * <p>
     * The requested blueprint in YAML format.
     * </p>
     * 
     * @return The requested blueprint in YAML format.
     */
    public final PipelineBlueprint blueprint() {
        return blueprint;
    }

    /**
     * <p>
     * The format of the blueprint.
     * </p>
     * 
     * @return The format of the blueprint.
     */
    public final String format() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueprint());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineBlueprintResponse)) {
            return false;
        }
        GetPipelineBlueprintResponse other = (GetPipelineBlueprintResponse) obj;
        return Objects.equals(blueprint(), other.blueprint()) && Objects.equals(format(), other.format());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPipelineBlueprintResponse").add("Blueprint", blueprint()).add("Format", format()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Blueprint":
            return Optional.ofNullable(clazz.cast(blueprint()));
        case "Format":
            return Optional.ofNullable(clazz.cast(format()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Blueprint", BLUEPRINT_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineBlueprintResponse, T> g) {
        return obj -> g.apply((GetPipelineBlueprintResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OsisResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPipelineBlueprintResponse> {
        /**
         * <p>
         * The requested blueprint in YAML format.
         * </p>
         * 
         * @param blueprint
         *        The requested blueprint in YAML format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprint(PipelineBlueprint blueprint);

        /**
         * <p>
         * The requested blueprint in YAML format.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipelineBlueprint.Builder} avoiding the
         * need to create one manually via {@link PipelineBlueprint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineBlueprint.Builder#build()} is called immediately and its
         * result is passed to {@link #blueprint(PipelineBlueprint)}.
         * 
         * @param blueprint
         *        a consumer that will call methods on {@link PipelineBlueprint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprint(PipelineBlueprint)
         */
        default Builder blueprint(Consumer<PipelineBlueprint.Builder> blueprint) {
            return blueprint(PipelineBlueprint.builder().applyMutation(blueprint).build());
        }

        /**
         * <p>
         * The format of the blueprint.
         * </p>
         * 
         * @param format
         *        The format of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);
    }

    static final class BuilderImpl extends OsisResponse.BuilderImpl implements Builder {
        private PipelineBlueprint blueprint;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineBlueprintResponse model) {
            super(model);
            blueprint(model.blueprint);
            format(model.format);
        }

        public final PipelineBlueprint.Builder getBlueprint() {
            return blueprint != null ? blueprint.toBuilder() : null;
        }

        public final void setBlueprint(PipelineBlueprint.BuilderImpl blueprint) {
            this.blueprint = blueprint != null ? blueprint.build() : null;
        }

        @Override
        public final Builder blueprint(PipelineBlueprint blueprint) {
            this.blueprint = blueprint;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public GetPipelineBlueprintResponse build() {
            return new GetPipelineBlueprintResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
