/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPipelineChangeProgressResponse extends OsisResponse implements
        ToCopyableBuilder<GetPipelineChangeProgressResponse.Builder, GetPipelineChangeProgressResponse> {
    private static final SdkField<List<ChangeProgressStatus>> CHANGE_PROGRESS_STATUSES_FIELD = SdkField
            .<List<ChangeProgressStatus>> builder(MarshallingType.LIST)
            .memberName("ChangeProgressStatuses")
            .getter(getter(GetPipelineChangeProgressResponse::changeProgressStatuses))
            .setter(setter(Builder::changeProgressStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeProgressStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeProgressStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CHANGE_PROGRESS_STATUSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ChangeProgressStatus> changeProgressStatuses;

    private GetPipelineChangeProgressResponse(BuilderImpl builder) {
        super(builder);
        this.changeProgressStatuses = builder.changeProgressStatuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeProgressStatuses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasChangeProgressStatuses() {
        return changeProgressStatuses != null && !(changeProgressStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current status of the change happening on the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeProgressStatuses} method.
     * </p>
     * 
     * @return The current status of the change happening on the pipeline.
     */
    public final List<ChangeProgressStatus> changeProgressStatuses() {
        return changeProgressStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeProgressStatuses() ? changeProgressStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineChangeProgressResponse)) {
            return false;
        }
        GetPipelineChangeProgressResponse other = (GetPipelineChangeProgressResponse) obj;
        return hasChangeProgressStatuses() == other.hasChangeProgressStatuses()
                && Objects.equals(changeProgressStatuses(), other.changeProgressStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPipelineChangeProgressResponse")
                .add("ChangeProgressStatuses", hasChangeProgressStatuses() ? changeProgressStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeProgressStatuses":
            return Optional.ofNullable(clazz.cast(changeProgressStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChangeProgressStatuses", CHANGE_PROGRESS_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineChangeProgressResponse, T> g) {
        return obj -> g.apply((GetPipelineChangeProgressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OsisResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPipelineChangeProgressResponse> {
        /**
         * <p>
         * The current status of the change happening on the pipeline.
         * </p>
         * 
         * @param changeProgressStatuses
         *        The current status of the change happening on the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressStatuses(Collection<ChangeProgressStatus> changeProgressStatuses);

        /**
         * <p>
         * The current status of the change happening on the pipeline.
         * </p>
         * 
         * @param changeProgressStatuses
         *        The current status of the change happening on the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressStatuses(ChangeProgressStatus... changeProgressStatuses);

        /**
         * <p>
         * The current status of the change happening on the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.osis.model.ChangeProgressStatus.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.osis.model.ChangeProgressStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.osis.model.ChangeProgressStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #changeProgressStatuses(List<ChangeProgressStatus>)}.
         * 
         * @param changeProgressStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.osis.model.ChangeProgressStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeProgressStatuses(java.util.Collection<ChangeProgressStatus>)
         */
        Builder changeProgressStatuses(Consumer<ChangeProgressStatus.Builder>... changeProgressStatuses);
    }

    static final class BuilderImpl extends OsisResponse.BuilderImpl implements Builder {
        private List<ChangeProgressStatus> changeProgressStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineChangeProgressResponse model) {
            super(model);
            changeProgressStatuses(model.changeProgressStatuses);
        }

        public final List<ChangeProgressStatus.Builder> getChangeProgressStatuses() {
            List<ChangeProgressStatus.Builder> result = ChangeProgressStatusListCopier.copyToBuilder(this.changeProgressStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeProgressStatuses(Collection<ChangeProgressStatus.BuilderImpl> changeProgressStatuses) {
            this.changeProgressStatuses = ChangeProgressStatusListCopier.copyFromBuilder(changeProgressStatuses);
        }

        @Override
        public final Builder changeProgressStatuses(Collection<ChangeProgressStatus> changeProgressStatuses) {
            this.changeProgressStatuses = ChangeProgressStatusListCopier.copy(changeProgressStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStatuses(ChangeProgressStatus... changeProgressStatuses) {
            changeProgressStatuses(Arrays.asList(changeProgressStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStatuses(Consumer<ChangeProgressStatus.Builder>... changeProgressStatuses) {
            changeProgressStatuses(Stream.of(changeProgressStatuses)
                    .map(c -> ChangeProgressStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPipelineChangeProgressResponse build() {
            return new GetPipelineChangeProgressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
