/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.osis.OsisClient;
import software.amazon.awssdk.services.osis.OsisServiceClientConfiguration;
import software.amazon.awssdk.services.osis.internal.OsisServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.osis.model.AccessDeniedException;
import software.amazon.awssdk.services.osis.model.ConflictException;
import software.amazon.awssdk.services.osis.model.CreatePipelineEndpointRequest;
import software.amazon.awssdk.services.osis.model.CreatePipelineEndpointResponse;
import software.amazon.awssdk.services.osis.model.CreatePipelineRequest;
import software.amazon.awssdk.services.osis.model.CreatePipelineResponse;
import software.amazon.awssdk.services.osis.model.DeletePipelineEndpointRequest;
import software.amazon.awssdk.services.osis.model.DeletePipelineEndpointResponse;
import software.amazon.awssdk.services.osis.model.DeletePipelineRequest;
import software.amazon.awssdk.services.osis.model.DeletePipelineResponse;
import software.amazon.awssdk.services.osis.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.osis.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.osis.model.DisabledOperationException;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineBlueprintResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineChangeProgressResponse;
import software.amazon.awssdk.services.osis.model.GetPipelineRequest;
import software.amazon.awssdk.services.osis.model.GetPipelineResponse;
import software.amazon.awssdk.services.osis.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.osis.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.osis.model.InternalException;
import software.amazon.awssdk.services.osis.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.osis.model.LimitExceededException;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineBlueprintsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsResponse;
import software.amazon.awssdk.services.osis.model.ListPipelinesRequest;
import software.amazon.awssdk.services.osis.model.ListPipelinesResponse;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.osis.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.osis.model.OsisException;
import software.amazon.awssdk.services.osis.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.osis.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.osis.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.osis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.osis.model.RevokePipelineEndpointConnectionsRequest;
import software.amazon.awssdk.services.osis.model.RevokePipelineEndpointConnectionsResponse;
import software.amazon.awssdk.services.osis.model.StartPipelineRequest;
import software.amazon.awssdk.services.osis.model.StartPipelineResponse;
import software.amazon.awssdk.services.osis.model.StopPipelineRequest;
import software.amazon.awssdk.services.osis.model.StopPipelineResponse;
import software.amazon.awssdk.services.osis.model.TagResourceRequest;
import software.amazon.awssdk.services.osis.model.TagResourceResponse;
import software.amazon.awssdk.services.osis.model.UntagResourceRequest;
import software.amazon.awssdk.services.osis.model.UntagResourceResponse;
import software.amazon.awssdk.services.osis.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.osis.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidatePipelineRequest;
import software.amazon.awssdk.services.osis.model.ValidatePipelineResponse;
import software.amazon.awssdk.services.osis.model.ValidationException;
import software.amazon.awssdk.services.osis.transform.CreatePipelineEndpointRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.CreatePipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.DeletePipelineEndpointRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.DeletePipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.GetPipelineBlueprintRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.GetPipelineChangeProgressRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.GetPipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListPipelineBlueprintsRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListPipelineEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListPipelineEndpointsRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListPipelinesRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.RevokePipelineEndpointConnectionsRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.StartPipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.StopPipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.UpdatePipelineRequestMarshaller;
import software.amazon.awssdk.services.osis.transform.ValidatePipelineRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultOsisClient
implements OsisClient {
    private static final Logger log = Logger.loggerFor(DefaultOsisClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOsisClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"OSIS#2.34.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResponse createPipeline(CreatePipelineRequest createPipelineRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, createPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipeline");
            CreatePipelineResponse createPipelineResponse = (CreatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$createPipeline$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineEndpointResponse createPipelineEndpoint(CreatePipelineEndpointRequest createPipelineEndpointRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePipelineEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPipelineEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, createPipelineEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePipelineEndpoint");
            CreatePipelineEndpointResponse createPipelineEndpointResponse = (CreatePipelineEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePipelineEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPipelineEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePipelineEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPipelineEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$createPipelineEndpoint$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineResponse deletePipeline(DeletePipelineRequest deletePipelineRequest) throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, deletePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipeline");
            DeletePipelineResponse deletePipelineResponse = (DeletePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$deletePipeline$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineEndpointResponse deletePipelineEndpoint(DeletePipelineEndpointRequest deletePipelineEndpointRequest) throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePipelineEndpointResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deletePipelineEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, deletePipelineEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePipelineEndpoint");
            DeletePipelineEndpointResponse deletePipelineEndpointResponse = (DeletePipelineEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePipelineEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deletePipelineEndpointRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeletePipelineEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deletePipelineEndpointResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$deletePipelineEndpoint$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$deleteResourcePolicy$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineResponse getPipeline(GetPipelineRequest getPipelineRequest) throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, getPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipeline");
            GetPipelineResponse getPipelineResponse = (GetPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$getPipeline$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineBlueprintResponse getPipelineBlueprint(GetPipelineBlueprintRequest getPipelineBlueprintRequest) throws DisabledOperationException, AccessDeniedException, InternalException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineBlueprintResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineBlueprintRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, getPipelineBlueprintRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineBlueprint");
            GetPipelineBlueprintResponse getPipelineBlueprintResponse = (GetPipelineBlueprintResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineBlueprint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineBlueprintRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineBlueprintRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineBlueprintResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$getPipelineBlueprint$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineChangeProgressResponse getPipelineChangeProgress(GetPipelineChangeProgressRequest getPipelineChangeProgressRequest) throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPipelineChangeProgressResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPipelineChangeProgressRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, getPipelineChangeProgressRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPipelineChangeProgress");
            GetPipelineChangeProgressResponse getPipelineChangeProgressResponse = (GetPipelineChangeProgressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPipelineChangeProgress").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPipelineChangeProgressRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPipelineChangeProgressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPipelineChangeProgressResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$getPipelineChangeProgress$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$getResourcePolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelineBlueprintsResponse listPipelineBlueprints(ListPipelineBlueprintsRequest listPipelineBlueprintsRequest) throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineBlueprintsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelineBlueprintsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, listPipelineBlueprintsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelineBlueprints");
            ListPipelineBlueprintsResponse listPipelineBlueprintsResponse = (ListPipelineBlueprintsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineBlueprints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelineBlueprintsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelineBlueprintsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelineBlueprintsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listPipelineBlueprints$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelineEndpointConnectionsResponse listPipelineEndpointConnections(ListPipelineEndpointConnectionsRequest listPipelineEndpointConnectionsRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineEndpointConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelineEndpointConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, listPipelineEndpointConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelineEndpointConnections");
            ListPipelineEndpointConnectionsResponse listPipelineEndpointConnectionsResponse = (ListPipelineEndpointConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineEndpointConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelineEndpointConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelineEndpointConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelineEndpointConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listPipelineEndpointConnections$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelineEndpointsResponse listPipelineEndpoints(ListPipelineEndpointsRequest listPipelineEndpointsRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelineEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelineEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, listPipelineEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelineEndpoints");
            ListPipelineEndpointsResponse listPipelineEndpointsResponse = (ListPipelineEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelineEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelineEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelineEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelineEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listPipelineEndpoints$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest listPipelinesRequest) throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPipelinesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPipelinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, listPipelinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPipelines");
            ListPipelinesResponse listPipelinesResponse = (ListPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPipelines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPipelinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPipelinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listPipelines$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws DisabledOperationException, ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$listTagsForResource$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            PutResourcePolicyResponse putResourcePolicyResponse = (PutResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$putResourcePolicy$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RevokePipelineEndpointConnectionsResponse revokePipelineEndpointConnections(RevokePipelineEndpointConnectionsRequest revokePipelineEndpointConnectionsRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokePipelineEndpointConnectionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokePipelineEndpointConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, revokePipelineEndpointConnectionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokePipelineEndpointConnections");
            RevokePipelineEndpointConnectionsResponse revokePipelineEndpointConnectionsResponse = (RevokePipelineEndpointConnectionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokePipelineEndpointConnections").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)revokePipelineEndpointConnectionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RevokePipelineEndpointConnectionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return revokePipelineEndpointConnectionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$revokePipelineEndpointConnections$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartPipelineResponse startPipeline(StartPipelineRequest startPipelineRequest) throws DisabledOperationException, AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartPipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, startPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartPipeline");
            StartPipelineResponse startPipelineResponse = (StartPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$startPipeline$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopPipelineResponse stopPipeline(StopPipelineRequest stopPipelineRequest) throws DisabledOperationException, AccessDeniedException, ConflictException, InternalException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopPipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopPipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, stopPipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopPipeline");
            StopPipelineResponse stopPipelineResponse = (StopPipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopPipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopPipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopPipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopPipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$stopPipeline$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws DisabledOperationException, LimitExceededException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$tagResource$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws DisabledOperationException, ValidationException, ResourceNotFoundException, InternalException, AccessDeniedException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$untagResource$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineResponse updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws DisabledOperationException, ValidationException, InternalException, AccessDeniedException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updatePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, updatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdatePipeline");
            UpdatePipelineResponse updatePipelineResponse = (UpdatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updatePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updatePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$updatePipeline$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatePipelineResponse validatePipeline(ValidatePipelineRequest validatePipelineRequest) throws DisabledOperationException, AccessDeniedException, InternalException, ValidationException, AwsServiceException, SdkClientException, OsisException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ValidatePipelineResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "DisabledOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisabledOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DisabledOperationException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
                case "InternalException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalException::builder).build());
                }
                case "InvalidPaginationTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidPaginationTokenException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)validatePipelineRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultOsisClient.resolveMetricPublishers(clientConfiguration, validatePipelineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"OSIS");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ValidatePipeline");
            ValidatePipelineResponse validatePipelineResponse = (ValidatePipelineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ValidatePipeline").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)validatePipelineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ValidatePipelineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return validatePipelineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOsisClient.lambda$validatePipeline$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "osis";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        OsisServiceClientConfigurationBuilder serviceConfigBuilder = new OsisServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OsisException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final OsisServiceClientConfiguration serviceClientConfiguration() {
        return new OsisServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$validatePipeline$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updatePipeline$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopPipeline$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startPipeline$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokePipelineEndpointConnections$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelines$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelineEndpoints$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelineEndpointConnections$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPipelineBlueprints$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineChangeProgress$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipelineBlueprint$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPipeline$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipelineEndpoint$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePipeline$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipelineEndpoint$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPipeline$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

