/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.osis.model.OsisRequest;
import software.amazon.awssdk.services.osis.model.PipelineEndpointVpcOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePipelineEndpointRequest
extends OsisRequest
implements ToCopyableBuilder<Builder, CreatePipelineEndpointRequest> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(CreatePipelineEndpointRequest.getter(CreatePipelineEndpointRequest::pipelineArn)).setter(CreatePipelineEndpointRequest.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<PipelineEndpointVpcOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOptions").getter(CreatePipelineEndpointRequest.getter(CreatePipelineEndpointRequest::vpcOptions)).setter(CreatePipelineEndpointRequest.setter(Builder::vpcOptions)).constructor(PipelineEndpointVpcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD, VPC_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePipelineEndpointRequest.memberNameToFieldInitializer();
    private final String pipelineArn;
    private final PipelineEndpointVpcOptions vpcOptions;

    private CreatePipelineEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.vpcOptions = builder.vpcOptions;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final PipelineEndpointVpcOptions vpcOptions() {
        return this.vpcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineEndpointRequest)) {
            return false;
        }
        CreatePipelineEndpointRequest other = (CreatePipelineEndpointRequest)((Object)obj);
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.vpcOptions(), other.vpcOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePipelineEndpointRequest").add("PipelineArn", (Object)this.pipelineArn()).add("VpcOptions", (Object)this.vpcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "VpcOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineEndpointRequest, T> g) {
        return obj -> g.apply((CreatePipelineEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisRequest.BuilderImpl
    implements Builder {
        private String pipelineArn;
        private PipelineEndpointVpcOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineEndpointRequest model) {
            super(model);
            this.pipelineArn(model.pipelineArn);
            this.vpcOptions(model.vpcOptions);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final PipelineEndpointVpcOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(PipelineEndpointVpcOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(PipelineEndpointVpcOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineEndpointRequest build() {
            return new CreatePipelineEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePipelineEndpointRequest> {
        public Builder pipelineArn(String var1);

        public Builder vpcOptions(PipelineEndpointVpcOptions var1);

        default public Builder vpcOptions(Consumer<PipelineEndpointVpcOptions.Builder> vpcOptions) {
            return this.vpcOptions((PipelineEndpointVpcOptions)((PipelineEndpointVpcOptions.Builder)PipelineEndpointVpcOptions.builder().applyMutation(vpcOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

