/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.osis.model.PipelineEndpointStatus;
import software.amazon.awssdk.services.osis.model.PipelineEndpointVpcOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineEndpoint> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(PipelineEndpoint.getter(PipelineEndpoint::pipelineArn)).setter(PipelineEndpoint.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(PipelineEndpoint.getter(PipelineEndpoint::endpointId)).setter(PipelineEndpoint.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(PipelineEndpoint.getter(PipelineEndpoint::statusAsString)).setter(PipelineEndpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(PipelineEndpoint.getter(PipelineEndpoint::vpcId)).setter(PipelineEndpoint.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<PipelineEndpointVpcOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcOptions").getter(PipelineEndpoint.getter(PipelineEndpoint::vpcOptions)).setter(PipelineEndpoint.setter(Builder::vpcOptions)).constructor(PipelineEndpointVpcOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOptions").build()}).build();
    private static final SdkField<String> INGEST_ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestEndpointUrl").getter(PipelineEndpoint.getter(PipelineEndpoint::ingestEndpointUrl)).setter(PipelineEndpoint.setter(Builder::ingestEndpointUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestEndpointUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD, ENDPOINT_ID_FIELD, STATUS_FIELD, VPC_ID_FIELD, VPC_OPTIONS_FIELD, INGEST_ENDPOINT_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineArn;
    private final String endpointId;
    private final String status;
    private final String vpcId;
    private final PipelineEndpointVpcOptions vpcOptions;
    private final String ingestEndpointUrl;

    private PipelineEndpoint(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.endpointId = builder.endpointId;
        this.status = builder.status;
        this.vpcId = builder.vpcId;
        this.vpcOptions = builder.vpcOptions;
        this.ingestEndpointUrl = builder.ingestEndpointUrl;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final PipelineEndpointStatus status() {
        return PipelineEndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final PipelineEndpointVpcOptions vpcOptions() {
        return this.vpcOptions;
    }

    public final String ingestEndpointUrl() {
        return this.ingestEndpointUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestEndpointUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineEndpoint)) {
            return false;
        }
        PipelineEndpoint other = (PipelineEndpoint)obj;
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.ingestEndpointUrl(), other.ingestEndpointUrl());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineEndpoint").add("PipelineArn", (Object)this.pipelineArn()).add("EndpointId", (Object)this.endpointId()).add("Status", (Object)this.statusAsString()).add("VpcId", (Object)this.vpcId()).add("VpcOptions", (Object)this.vpcOptions()).add("IngestEndpointUrl", (Object)this.ingestEndpointUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "VpcOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "IngestEndpointUrl": {
                return Optional.ofNullable(clazz.cast(this.ingestEndpointUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("VpcOptions", VPC_OPTIONS_FIELD);
        map.put("IngestEndpointUrl", INGEST_ENDPOINT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineEndpoint, T> g) {
        return obj -> g.apply((PipelineEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineArn;
        private String endpointId;
        private String status;
        private String vpcId;
        private PipelineEndpointVpcOptions vpcOptions;
        private String ingestEndpointUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineEndpoint model) {
            this.pipelineArn(model.pipelineArn);
            this.endpointId(model.endpointId);
            this.status(model.status);
            this.vpcId(model.vpcId);
            this.vpcOptions(model.vpcOptions);
            this.ingestEndpointUrl(model.ingestEndpointUrl);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final PipelineEndpointVpcOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(PipelineEndpointVpcOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(PipelineEndpointVpcOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final String getIngestEndpointUrl() {
            return this.ingestEndpointUrl;
        }

        public final void setIngestEndpointUrl(String ingestEndpointUrl) {
            this.ingestEndpointUrl = ingestEndpointUrl;
        }

        @Override
        public final Builder ingestEndpointUrl(String ingestEndpointUrl) {
            this.ingestEndpointUrl = ingestEndpointUrl;
            return this;
        }

        public PipelineEndpoint build() {
            return new PipelineEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineEndpoint> {
        public Builder pipelineArn(String var1);

        public Builder endpointId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineEndpointStatus var1);

        public Builder vpcId(String var1);

        public Builder vpcOptions(PipelineEndpointVpcOptions var1);

        default public Builder vpcOptions(Consumer<PipelineEndpointVpcOptions.Builder> vpcOptions) {
            return this.vpcOptions((PipelineEndpointVpcOptions)((PipelineEndpointVpcOptions.Builder)PipelineEndpointVpcOptions.builder().applyMutation(vpcOptions)).build());
        }

        public Builder ingestEndpointUrl(String var1);
    }
}

