/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.OsisRequest;
import software.amazon.awssdk.services.osis.model.PipelineEndpointIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevokePipelineEndpointConnectionsRequest
extends OsisRequest
implements ToCopyableBuilder<Builder, RevokePipelineEndpointConnectionsRequest> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineArn").getter(RevokePipelineEndpointConnectionsRequest.getter(RevokePipelineEndpointConnectionsRequest::pipelineArn)).setter(RevokePipelineEndpointConnectionsRequest.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()}).build();
    private static final SdkField<List<String>> ENDPOINT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointIds").getter(RevokePipelineEndpointConnectionsRequest.getter(RevokePipelineEndpointConnectionsRequest::endpointIds)).setter(RevokePipelineEndpointConnectionsRequest.setter(Builder::endpointIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD, ENDPOINT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevokePipelineEndpointConnectionsRequest.memberNameToFieldInitializer();
    private final String pipelineArn;
    private final List<String> endpointIds;

    private RevokePipelineEndpointConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineArn = builder.pipelineArn;
        this.endpointIds = builder.endpointIds;
    }

    public final String pipelineArn() {
        return this.pipelineArn;
    }

    public final boolean hasEndpointIds() {
        return this.endpointIds != null && !(this.endpointIds instanceof SdkAutoConstructList);
    }

    public final List<String> endpointIds() {
        return this.endpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointIds() ? this.endpointIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokePipelineEndpointConnectionsRequest)) {
            return false;
        }
        RevokePipelineEndpointConnectionsRequest other = (RevokePipelineEndpointConnectionsRequest)((Object)obj);
        return Objects.equals(this.pipelineArn(), other.pipelineArn()) && this.hasEndpointIds() == other.hasEndpointIds() && Objects.equals(this.endpointIds(), other.endpointIds());
    }

    public final String toString() {
        return ToString.builder((String)"RevokePipelineEndpointConnectionsRequest").add("PipelineArn", (Object)this.pipelineArn()).add("EndpointIds", this.hasEndpointIds() ? this.endpointIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
            case "EndpointIds": {
                return Optional.ofNullable(clazz.cast(this.endpointIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PipelineArn", PIPELINE_ARN_FIELD);
        map.put("EndpointIds", ENDPOINT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokePipelineEndpointConnectionsRequest, T> g) {
        return obj -> g.apply((RevokePipelineEndpointConnectionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisRequest.BuilderImpl
    implements Builder {
        private String pipelineArn;
        private List<String> endpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RevokePipelineEndpointConnectionsRequest model) {
            super(model);
            this.pipelineArn(model.pipelineArn);
            this.endpointIds(model.endpointIds);
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final Collection<String> getEndpointIds() {
            if (this.endpointIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpointIds;
        }

        public final void setEndpointIds(Collection<String> endpointIds) {
            this.endpointIds = PipelineEndpointIdsListCopier.copy(endpointIds);
        }

        @Override
        public final Builder endpointIds(Collection<String> endpointIds) {
            this.endpointIds = PipelineEndpointIdsListCopier.copy(endpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointIds(String ... endpointIds) {
            this.endpointIds(Arrays.asList(endpointIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokePipelineEndpointConnectionsRequest build() {
            return new RevokePipelineEndpointConnectionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RevokePipelineEndpointConnectionsRequest> {
        public Builder pipelineArn(String var1);

        public Builder endpointIds(Collection<String> var1);

        public Builder endpointIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

