/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.OsisResponse;
import software.amazon.awssdk.services.osis.model.ValidationMessage;
import software.amazon.awssdk.services.osis.model.ValidationMessageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidatePipelineResponse
extends OsisResponse
implements ToCopyableBuilder<Builder, ValidatePipelineResponse> {
    private static final SdkField<Boolean> IS_VALID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isValid").getter(ValidatePipelineResponse.getter(ValidatePipelineResponse::isValid)).setter(ValidatePipelineResponse.setter(Builder::isValid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isValid").build()}).build();
    private static final SdkField<List<ValidationMessage>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(ValidatePipelineResponse.getter(ValidatePipelineResponse::errors)).setter(ValidatePipelineResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_VALID_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidatePipelineResponse.memberNameToFieldInitializer();
    private final Boolean isValid;
    private final List<ValidationMessage> errors;

    private ValidatePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.isValid = builder.isValid;
        this.errors = builder.errors;
    }

    public final Boolean isValid() {
        return this.isValid;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<ValidationMessage> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.isValid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineResponse)) {
            return false;
        }
        ValidatePipelineResponse other = (ValidatePipelineResponse)((Object)obj);
        return Objects.equals(this.isValid(), other.isValid()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"ValidatePipelineResponse").add("IsValid", (Object)this.isValid()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isValid": {
                return Optional.ofNullable(clazz.cast(this.isValid()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isValid", IS_VALID_FIELD);
        map.put("Errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidatePipelineResponse, T> g) {
        return obj -> g.apply((ValidatePipelineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OsisResponse.BuilderImpl
    implements Builder {
        private Boolean isValid;
        private List<ValidationMessage> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePipelineResponse model) {
            super(model);
            this.isValid(model.isValid);
            this.errors(model.errors);
        }

        public final Boolean getIsValid() {
            return this.isValid;
        }

        public final void setIsValid(Boolean isValid) {
            this.isValid = isValid;
        }

        @Override
        public final Builder isValid(Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public final List<ValidationMessage.Builder> getErrors() {
            List<ValidationMessage.Builder> result = ValidationMessageListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ValidationMessage.BuilderImpl> errors) {
            this.errors = ValidationMessageListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ValidationMessage> errors) {
            this.errors = ValidationMessageListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ValidationMessage ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ValidationMessage.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ValidationMessage)((ValidationMessage.Builder)ValidationMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValidatePipelineResponse build() {
            return new ValidatePipelineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OsisResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidatePipelineResponse> {
        public Builder isValid(Boolean var1);

        public Builder errors(Collection<ValidationMessage> var1);

        public Builder errors(ValidationMessage ... var1);

        public Builder errors(Consumer<ValidationMessage.Builder> ... var1);
    }
}

