/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.osis.OsisAsyncClient;
import software.amazon.awssdk.services.osis.internal.UserAgentUtils;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointConnectionsResponse;
import software.amazon.awssdk.services.osis.model.PipelineEndpointConnection;

public class ListPipelineEndpointConnectionsPublisher
implements SdkPublisher<ListPipelineEndpointConnectionsResponse> {
    private final OsisAsyncClient client;
    private final ListPipelineEndpointConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelineEndpointConnectionsPublisher(OsisAsyncClient client, ListPipelineEndpointConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelineEndpointConnectionsPublisher(OsisAsyncClient client, ListPipelineEndpointConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelineEndpointConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelineEndpointConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PipelineEndpointConnection> pipelineEndpointConnections() {
        Function<ListPipelineEndpointConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineEndpointConnections() != null) {
                return response.pipelineEndpointConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelineEndpointConnectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipelineEndpointConnectionsResponseFetcher
    implements AsyncPageFetcher<ListPipelineEndpointConnectionsResponse> {
        private ListPipelineEndpointConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineEndpointConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelineEndpointConnectionsResponse> nextPage(ListPipelineEndpointConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineEndpointConnectionsPublisher.this.client.listPipelineEndpointConnections(ListPipelineEndpointConnectionsPublisher.this.firstRequest);
            }
            return ListPipelineEndpointConnectionsPublisher.this.client.listPipelineEndpointConnections((ListPipelineEndpointConnectionsRequest)((Object)ListPipelineEndpointConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

