/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.osis.OsisAsyncClient;
import software.amazon.awssdk.services.osis.internal.UserAgentUtils;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsRequest;
import software.amazon.awssdk.services.osis.model.ListPipelineEndpointsResponse;
import software.amazon.awssdk.services.osis.model.PipelineEndpoint;

public class ListPipelineEndpointsPublisher
implements SdkPublisher<ListPipelineEndpointsResponse> {
    private final OsisAsyncClient client;
    private final ListPipelineEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelineEndpointsPublisher(OsisAsyncClient client, ListPipelineEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelineEndpointsPublisher(OsisAsyncClient client, ListPipelineEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelineEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelineEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PipelineEndpoint> pipelineEndpoints() {
        Function<ListPipelineEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineEndpoints() != null) {
                return response.pipelineEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelineEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipelineEndpointsResponseFetcher
    implements AsyncPageFetcher<ListPipelineEndpointsResponse> {
        private ListPipelineEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelineEndpointsResponse> nextPage(ListPipelineEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineEndpointsPublisher.this.client.listPipelineEndpoints(ListPipelineEndpointsPublisher.this.firstRequest);
            }
            return ListPipelineEndpointsPublisher.this.client.listPipelineEndpoints((ListPipelineEndpointsRequest)((Object)ListPipelineEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

