/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribeDeviceResponse.Builder, DescribeDeviceResponse> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(DescribeDeviceResponse::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeDeviceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeDeviceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeDeviceResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeDeviceResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DEVICE_CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceConnectionStatus").getter(getter(DescribeDeviceResponse::deviceConnectionStatusAsString))
            .setter(setter(Builder::deviceConnectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConnectionStatus").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeDeviceResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus").getter(getter(DescribeDeviceResponse::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build())
            .build();

    private static final SdkField<String> LATEST_SOFTWARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestSoftware").getter(getter(DescribeDeviceResponse::latestSoftware))
            .setter(setter(Builder::latestSoftware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSoftware").build()).build();

    private static final SdkField<String> CURRENT_SOFTWARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentSoftware").getter(getter(DescribeDeviceResponse::currentSoftware))
            .setter(setter(Builder::currentSoftware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSoftware").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(DescribeDeviceResponse::serialNumber))
            .setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeDeviceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<NetworkPayload> NETWORKING_CONFIGURATION_FIELD = SdkField
            .<NetworkPayload> builder(MarshallingType.SDK_POJO).memberName("NetworkingConfiguration")
            .getter(getter(DescribeDeviceResponse::networkingConfiguration)).setter(setter(Builder::networkingConfiguration))
            .constructor(NetworkPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkingConfiguration").build())
            .build();

    private static final SdkField<NetworkStatus> CURRENT_NETWORKING_STATUS_FIELD = SdkField
            .<NetworkStatus> builder(MarshallingType.SDK_POJO).memberName("CurrentNetworkingStatus")
            .getter(getter(DescribeDeviceResponse::currentNetworkingStatus)).setter(setter(Builder::currentNetworkingStatus))
            .constructor(NetworkStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentNetworkingStatus").build())
            .build();

    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LeaseExpirationTime").getter(getter(DescribeDeviceResponse::leaseExpirationTime))
            .setter(setter(Builder::leaseExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, NAME_FIELD,
            ARN_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DEVICE_CONNECTION_STATUS_FIELD, CREATED_TIME_FIELD,
            PROVISIONING_STATUS_FIELD, LATEST_SOFTWARE_FIELD, CURRENT_SOFTWARE_FIELD, SERIAL_NUMBER_FIELD, TAGS_FIELD,
            NETWORKING_CONFIGURATION_FIELD, CURRENT_NETWORKING_STATUS_FIELD, LEASE_EXPIRATION_TIME_FIELD));

    private final String deviceId;

    private final String name;

    private final String arn;

    private final String description;

    private final String type;

    private final String deviceConnectionStatus;

    private final Instant createdTime;

    private final String provisioningStatus;

    private final String latestSoftware;

    private final String currentSoftware;

    private final String serialNumber;

    private final Map<String, String> tags;

    private final NetworkPayload networkingConfiguration;

    private final NetworkStatus currentNetworkingStatus;

    private final Instant leaseExpirationTime;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.type = builder.type;
        this.deviceConnectionStatus = builder.deviceConnectionStatus;
        this.createdTime = builder.createdTime;
        this.provisioningStatus = builder.provisioningStatus;
        this.latestSoftware = builder.latestSoftware;
        this.currentSoftware = builder.currentSoftware;
        this.serialNumber = builder.serialNumber;
        this.tags = builder.tags;
        this.networkingConfiguration = builder.networkingConfiguration;
        this.currentNetworkingStatus = builder.currentNetworkingStatus;
        this.leaseExpirationTime = builder.leaseExpirationTime;
    }

    /**
     * <p>
     * The device's ID.
     * </p>
     * 
     * @return The device's ID.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The device's name.
     * </p>
     * 
     * @return The device's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The device's ARN.
     * </p>
     * 
     * @return The device's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The device's description.
     * </p>
     * 
     * @return The device's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final DeviceType type() {
        return DeviceType.fromValue(type);
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The device's connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceConnectionStatus} will return {@link DeviceConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceConnectionStatusAsString}.
     * </p>
     * 
     * @return The device's connection status.
     * @see DeviceConnectionStatus
     */
    public final DeviceConnectionStatus deviceConnectionStatus() {
        return DeviceConnectionStatus.fromValue(deviceConnectionStatus);
    }

    /**
     * <p>
     * The device's connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceConnectionStatus} will return {@link DeviceConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceConnectionStatusAsString}.
     * </p>
     * 
     * @return The device's connection status.
     * @see DeviceConnectionStatus
     */
    public final String deviceConnectionStatusAsString() {
        return deviceConnectionStatus;
    }

    /**
     * <p>
     * When the device was created.
     * </p>
     * 
     * @return When the device was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    /**
     * <p>
     * The latest software version available for the device.
     * </p>
     * 
     * @return The latest software version available for the device.
     */
    public final String latestSoftware() {
        return latestSoftware;
    }

    /**
     * <p>
     * The device's current software version.
     * </p>
     * 
     * @return The device's current software version.
     */
    public final String currentSoftware() {
        return currentSoftware;
    }

    /**
     * <p>
     * The device's serial number.
     * </p>
     * 
     * @return The device's serial number.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The device's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The device's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The device's networking configuration.
     * </p>
     * 
     * @return The device's networking configuration.
     */
    public final NetworkPayload networkingConfiguration() {
        return networkingConfiguration;
    }

    /**
     * <p>
     * The device's networking status.
     * </p>
     * 
     * @return The device's networking status.
     */
    public final NetworkStatus currentNetworkingStatus() {
        return currentNetworkingStatus;
    }

    /**
     * <p>
     * The device's lease expiration time.
     * </p>
     * 
     * @return The device's lease expiration time.
     */
    public final Instant leaseExpirationTime() {
        return leaseExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConnectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(currentSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(currentNetworkingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(leaseExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(name(), other.name())
                && Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(deviceConnectionStatusAsString(), other.deviceConnectionStatusAsString())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString())
                && Objects.equals(latestSoftware(), other.latestSoftware())
                && Objects.equals(currentSoftware(), other.currentSoftware())
                && Objects.equals(serialNumber(), other.serialNumber()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(networkingConfiguration(), other.networkingConfiguration())
                && Objects.equals(currentNetworkingStatus(), other.currentNetworkingStatus())
                && Objects.equals(leaseExpirationTime(), other.leaseExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceResponse").add("DeviceId", deviceId()).add("Name", name()).add("Arn", arn())
                .add("Description", description()).add("Type", typeAsString())
                .add("DeviceConnectionStatus", deviceConnectionStatusAsString()).add("CreatedTime", createdTime())
                .add("ProvisioningStatus", provisioningStatusAsString()).add("LatestSoftware", latestSoftware())
                .add("CurrentSoftware", currentSoftware()).add("SerialNumber", serialNumber())
                .add("Tags", hasTags() ? tags() : null).add("NetworkingConfiguration", networkingConfiguration())
                .add("CurrentNetworkingStatus", currentNetworkingStatus()).add("LeaseExpirationTime", leaseExpirationTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DeviceConnectionStatus":
            return Optional.ofNullable(clazz.cast(deviceConnectionStatusAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        case "LatestSoftware":
            return Optional.ofNullable(clazz.cast(latestSoftware()));
        case "CurrentSoftware":
            return Optional.ofNullable(clazz.cast(currentSoftware()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NetworkingConfiguration":
            return Optional.ofNullable(clazz.cast(networkingConfiguration()));
        case "CurrentNetworkingStatus":
            return Optional.ofNullable(clazz.cast(currentNetworkingStatus()));
        case "LeaseExpirationTime":
            return Optional.ofNullable(clazz.cast(leaseExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeviceResponse> {
        /**
         * <p>
         * The device's ID.
         * </p>
         * 
         * @param deviceId
         *        The device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The device's name.
         * </p>
         * 
         * @param name
         *        The device's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device's ARN.
         * </p>
         * 
         * @param arn
         *        The device's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The device's description.
         * </p>
         * 
         * @param description
         *        The device's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param type
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder type(String type);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param type
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder type(DeviceType type);

        /**
         * <p>
         * The device's connection status.
         * </p>
         * 
         * @param deviceConnectionStatus
         *        The device's connection status.
         * @see DeviceConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceConnectionStatus
         */
        Builder deviceConnectionStatus(String deviceConnectionStatus);

        /**
         * <p>
         * The device's connection status.
         * </p>
         * 
         * @param deviceConnectionStatus
         *        The device's connection status.
         * @see DeviceConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceConnectionStatus
         */
        Builder deviceConnectionStatus(DeviceConnectionStatus deviceConnectionStatus);

        /**
         * <p>
         * When the device was created.
         * </p>
         * 
         * @param createdTime
         *        When the device was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(DeviceStatus provisioningStatus);

        /**
         * <p>
         * The latest software version available for the device.
         * </p>
         * 
         * @param latestSoftware
         *        The latest software version available for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSoftware(String latestSoftware);

        /**
         * <p>
         * The device's current software version.
         * </p>
         * 
         * @param currentSoftware
         *        The device's current software version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSoftware(String currentSoftware);

        /**
         * <p>
         * The device's serial number.
         * </p>
         * 
         * @param serialNumber
         *        The device's serial number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The device's tags.
         * </p>
         * 
         * @param tags
         *        The device's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The device's networking configuration.
         * </p>
         * 
         * @param networkingConfiguration
         *        The device's networking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkingConfiguration(NetworkPayload networkingConfiguration);

        /**
         * <p>
         * The device's networking configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkPayload.Builder} avoiding the need to
         * create one manually via {@link NetworkPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #networkingConfiguration(NetworkPayload)}.
         * 
         * @param networkingConfiguration
         *        a consumer that will call methods on {@link NetworkPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkingConfiguration(NetworkPayload)
         */
        default Builder networkingConfiguration(Consumer<NetworkPayload.Builder> networkingConfiguration) {
            return networkingConfiguration(NetworkPayload.builder().applyMutation(networkingConfiguration).build());
        }

        /**
         * <p>
         * The device's networking status.
         * </p>
         * 
         * @param currentNetworkingStatus
         *        The device's networking status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentNetworkingStatus(NetworkStatus currentNetworkingStatus);

        /**
         * <p>
         * The device's networking status.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkStatus.Builder} avoiding the need to
         * create one manually via {@link NetworkStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #currentNetworkingStatus(NetworkStatus)}.
         * 
         * @param currentNetworkingStatus
         *        a consumer that will call methods on {@link NetworkStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentNetworkingStatus(NetworkStatus)
         */
        default Builder currentNetworkingStatus(Consumer<NetworkStatus.Builder> currentNetworkingStatus) {
            return currentNetworkingStatus(NetworkStatus.builder().applyMutation(currentNetworkingStatus).build());
        }

        /**
         * <p>
         * The device's lease expiration time.
         * </p>
         * 
         * @param leaseExpirationTime
         *        The device's lease expiration time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leaseExpirationTime(Instant leaseExpirationTime);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String deviceId;

        private String name;

        private String arn;

        private String description;

        private String type;

        private String deviceConnectionStatus;

        private Instant createdTime;

        private String provisioningStatus;

        private String latestSoftware;

        private String currentSoftware;

        private String serialNumber;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private NetworkPayload networkingConfiguration;

        private NetworkStatus currentNetworkingStatus;

        private Instant leaseExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            deviceId(model.deviceId);
            name(model.name);
            arn(model.arn);
            description(model.description);
            type(model.type);
            deviceConnectionStatus(model.deviceConnectionStatus);
            createdTime(model.createdTime);
            provisioningStatus(model.provisioningStatus);
            latestSoftware(model.latestSoftware);
            currentSoftware(model.currentSoftware);
            serialNumber(model.serialNumber);
            tags(model.tags);
            networkingConfiguration(model.networkingConfiguration);
            currentNetworkingStatus(model.currentNetworkingStatus);
            leaseExpirationTime(model.leaseExpirationTime);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDeviceConnectionStatus() {
            return deviceConnectionStatus;
        }

        public final void setDeviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
        }

        @Override
        @Transient
        public final Builder deviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder deviceConnectionStatus(DeviceConnectionStatus deviceConnectionStatus) {
            this.deviceConnectionStatus(deviceConnectionStatus == null ? null : deviceConnectionStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getLatestSoftware() {
            return latestSoftware;
        }

        public final void setLatestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
        }

        @Override
        @Transient
        public final Builder latestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
            return this;
        }

        public final String getCurrentSoftware() {
            return currentSoftware;
        }

        public final void setCurrentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
        }

        @Override
        @Transient
        public final Builder currentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        @Transient
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final NetworkPayload.Builder getNetworkingConfiguration() {
            return networkingConfiguration != null ? networkingConfiguration.toBuilder() : null;
        }

        public final void setNetworkingConfiguration(NetworkPayload.BuilderImpl networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration != null ? networkingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder networkingConfiguration(NetworkPayload networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration;
            return this;
        }

        public final NetworkStatus.Builder getCurrentNetworkingStatus() {
            return currentNetworkingStatus != null ? currentNetworkingStatus.toBuilder() : null;
        }

        public final void setCurrentNetworkingStatus(NetworkStatus.BuilderImpl currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus != null ? currentNetworkingStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder currentNetworkingStatus(NetworkStatus currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        @Transient
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
