/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNodeFromTemplateJobResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribeNodeFromTemplateJobResponse.Builder, DescribeNodeFromTemplateJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(DescribeNodeFromTemplateJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeNodeFromTemplateJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DescribeNodeFromTemplateJobResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeNodeFromTemplateJobResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeNodeFromTemplateJobResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> OUTPUT_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputPackageName").getter(getter(DescribeNodeFromTemplateJobResponse::outputPackageName))
            .setter(setter(Builder::outputPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageName").build()).build();

    private static final SdkField<String> OUTPUT_PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputPackageVersion").getter(getter(DescribeNodeFromTemplateJobResponse::outputPackageVersion))
            .setter(setter(Builder::outputPackageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageVersion").build())
            .build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeName").getter(getter(DescribeNodeFromTemplateJobResponse::nodeName))
            .setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()).build();

    private static final SdkField<String> NODE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeDescription").getter(getter(DescribeNodeFromTemplateJobResponse::nodeDescription))
            .setter(setter(Builder::nodeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDescription").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(DescribeNodeFromTemplateJobResponse::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TemplateParameters")
            .getter(getter(DescribeNodeFromTemplateJobResponse::templateParameters))
            .setter(setter(Builder::templateParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField
            .<List<JobResourceTags>> builder(MarshallingType.LIST)
            .memberName("JobTags")
            .getter(getter(DescribeNodeFromTemplateJobResponse::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobResourceTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobResourceTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STATUS_FIELD,
            STATUS_MESSAGE_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, OUTPUT_PACKAGE_NAME_FIELD,
            OUTPUT_PACKAGE_VERSION_FIELD, NODE_NAME_FIELD, NODE_DESCRIPTION_FIELD, TEMPLATE_TYPE_FIELD,
            TEMPLATE_PARAMETERS_FIELD, JOB_TAGS_FIELD));

    private final String jobId;

    private final String status;

    private final String statusMessage;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String outputPackageName;

    private final String outputPackageVersion;

    private final String nodeName;

    private final String nodeDescription;

    private final String templateType;

    private final Map<String, String> templateParameters;

    private final List<JobResourceTags> jobTags;

    private DescribeNodeFromTemplateJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.outputPackageName = builder.outputPackageName;
        this.outputPackageVersion = builder.outputPackageVersion;
        this.nodeName = builder.nodeName;
        this.nodeDescription = builder.nodeDescription;
        this.templateType = builder.templateType;
        this.templateParameters = builder.templateParameters;
        this.jobTags = builder.jobTags;
    }

    /**
     * <p>
     * The job's ID.
     * </p>
     * 
     * @return The job's ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NodeFromTemplateJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see NodeFromTemplateJobStatus
     */
    public final NodeFromTemplateJobStatus status() {
        return NodeFromTemplateJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NodeFromTemplateJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see NodeFromTemplateJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The job's status message.
     * </p>
     * 
     * @return The job's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * When the job was updated.
     * </p>
     * 
     * @return When the job was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The job's output package name.
     * </p>
     * 
     * @return The job's output package name.
     */
    public final String outputPackageName() {
        return outputPackageName;
    }

    /**
     * <p>
     * The job's output package version.
     * </p>
     * 
     * @return The job's output package version.
     */
    public final String outputPackageVersion() {
        return outputPackageVersion;
    }

    /**
     * <p>
     * The node's name.
     * </p>
     * 
     * @return The node's name.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The node's description.
     * </p>
     * 
     * @return The node's description.
     */
    public final String nodeDescription() {
        return nodeDescription;
    }

    /**
     * <p>
     * The job's template type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The job's template type.
     * @see TemplateType
     */
    public final TemplateType templateType() {
        return TemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The job's template type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The job's template type.
     * @see TemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateParameters() {
        return templateParameters != null && !(templateParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The job's template parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateParameters} method.
     * </p>
     * 
     * @return The job's template parameters.
     */
    public final Map<String, String> templateParameters() {
        return templateParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The job's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return The job's tags.
     */
    public final List<JobResourceTags> jobTags() {
        return jobTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(outputPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(outputPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateParameters() ? templateParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeFromTemplateJobResponse)) {
            return false;
        }
        DescribeNodeFromTemplateJobResponse other = (DescribeNodeFromTemplateJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(outputPackageName(), other.outputPackageName())
                && Objects.equals(outputPackageVersion(), other.outputPackageVersion())
                && Objects.equals(nodeName(), other.nodeName()) && Objects.equals(nodeDescription(), other.nodeDescription())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && hasTemplateParameters() == other.hasTemplateParameters()
                && Objects.equals(templateParameters(), other.templateParameters()) && hasJobTags() == other.hasJobTags()
                && Objects.equals(jobTags(), other.jobTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNodeFromTemplateJobResponse").add("JobId", jobId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("OutputPackageName", outputPackageName())
                .add("OutputPackageVersion", outputPackageVersion()).add("NodeName", nodeName())
                .add("NodeDescription", nodeDescription()).add("TemplateType", templateTypeAsString())
                .add("TemplateParameters", templateParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JobTags", hasJobTags() ? jobTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "OutputPackageName":
            return Optional.ofNullable(clazz.cast(outputPackageName()));
        case "OutputPackageVersion":
            return Optional.ofNullable(clazz.cast(outputPackageVersion()));
        case "NodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "NodeDescription":
            return Optional.ofNullable(clazz.cast(nodeDescription()));
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "TemplateParameters":
            return Optional.ofNullable(clazz.cast(templateParameters()));
        case "JobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNodeFromTemplateJobResponse, T> g) {
        return obj -> g.apply((DescribeNodeFromTemplateJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNodeFromTemplateJobResponse> {
        /**
         * <p>
         * The job's ID.
         * </p>
         * 
         * @param jobId
         *        The job's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see NodeFromTemplateJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeFromTemplateJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see NodeFromTemplateJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeFromTemplateJobStatus
         */
        Builder status(NodeFromTemplateJobStatus status);

        /**
         * <p>
         * The job's status message.
         * </p>
         * 
         * @param statusMessage
         *        The job's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param createdTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * When the job was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        When the job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The job's output package name.
         * </p>
         * 
         * @param outputPackageName
         *        The job's output package name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputPackageName(String outputPackageName);

        /**
         * <p>
         * The job's output package version.
         * </p>
         * 
         * @param outputPackageVersion
         *        The job's output package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputPackageVersion(String outputPackageVersion);

        /**
         * <p>
         * The node's name.
         * </p>
         * 
         * @param nodeName
         *        The node's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The node's description.
         * </p>
         * 
         * @param nodeDescription
         *        The node's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDescription(String nodeDescription);

        /**
         * <p>
         * The job's template type.
         * </p>
         * 
         * @param templateType
         *        The job's template type.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The job's template type.
         * </p>
         * 
         * @param templateType
         *        The job's template type.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(TemplateType templateType);

        /**
         * <p>
         * The job's template parameters.
         * </p>
         * 
         * @param templateParameters
         *        The job's template parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateParameters(Map<String, String> templateParameters);

        /**
         * <p>
         * The job's tags.
         * </p>
         * 
         * @param jobTags
         *        The job's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Collection<JobResourceTags> jobTags);

        /**
         * <p>
         * The job's tags.
         * </p>
         * 
         * @param jobTags
         *        The job's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(JobResourceTags... jobTags);

        /**
         * <p>
         * The job's tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobResourceTags>.Builder} avoiding the need
         * to create one manually via {@link List<JobResourceTags>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobResourceTags>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobTags(List<JobResourceTags>)}.
         * 
         * @param jobTags
         *        a consumer that will call methods on {@link List<JobResourceTags>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTags(List<JobResourceTags>)
         */
        Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String jobId;

        private String status;

        private String statusMessage;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String outputPackageName;

        private String outputPackageVersion;

        private String nodeName;

        private String nodeDescription;

        private String templateType;

        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNodeFromTemplateJobResponse model) {
            super(model);
            jobId(model.jobId);
            status(model.status);
            statusMessage(model.statusMessage);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            outputPackageName(model.outputPackageName);
            outputPackageVersion(model.outputPackageVersion);
            nodeName(model.nodeName);
            nodeDescription(model.nodeDescription);
            templateType(model.templateType);
            templateParameters(model.templateParameters);
            jobTags(model.jobTags);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(NodeFromTemplateJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getOutputPackageName() {
            return outputPackageName;
        }

        public final void setOutputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
        }

        @Override
        @Transient
        public final Builder outputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
            return this;
        }

        public final String getOutputPackageVersion() {
            return outputPackageVersion;
        }

        public final void setOutputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
        }

        @Override
        @Transient
        public final Builder outputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        @Transient
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeDescription() {
            return nodeDescription;
        }

        public final void setNodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
        }

        @Override
        @Transient
        public final Builder nodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        @Transient
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        @Transient
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
        }

        @Override
        @Transient
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
            return this;
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        @Transient
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(JobResourceTags... jobTags) {
            jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags) {
            jobTags(Stream.of(jobTags).map(c -> JobResourceTags.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeNodeFromTemplateJobResponse build() {
            return new DescribeNodeFromTemplateJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
