/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePackageVersionResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribePackageVersionResponse.Builder, DescribePackageVersionResponse> {
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(DescribePackageVersionResponse::ownerAccount))
            .setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()).build();

    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageId").getter(getter(DescribePackageVersionResponse::packageId)).setter(setter(Builder::packageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()).build();

    private static final SdkField<String> PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageArn").getter(getter(DescribePackageVersionResponse::packageArn))
            .setter(setter(Builder::packageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageArn").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(DescribePackageVersionResponse::packageName))
            .setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(DescribePackageVersionResponse::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchVersion").getter(getter(DescribePackageVersionResponse::patchVersion))
            .setter(setter(Builder::patchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()).build();

    private static final SdkField<Boolean> IS_LATEST_PATCH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsLatestPatch").getter(getter(DescribePackageVersionResponse::isLatestPatch))
            .setter(setter(Builder::isLatestPatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsLatestPatch").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribePackageVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDescription").getter(getter(DescribePackageVersionResponse::statusDescription))
            .setter(setter(Builder::statusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()).build();

    private static final SdkField<Instant> REGISTERED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RegisteredTime").getter(getter(DescribePackageVersionResponse::registeredTime))
            .setter(setter(Builder::registeredTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_FIELD,
            PACKAGE_ID_FIELD, PACKAGE_ARN_FIELD, PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD,
            IS_LATEST_PATCH_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD, REGISTERED_TIME_FIELD));

    private final String ownerAccount;

    private final String packageId;

    private final String packageArn;

    private final String packageName;

    private final String packageVersion;

    private final String patchVersion;

    private final Boolean isLatestPatch;

    private final String status;

    private final String statusDescription;

    private final Instant registeredTime;

    private DescribePackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.ownerAccount = builder.ownerAccount;
        this.packageId = builder.packageId;
        this.packageArn = builder.packageArn;
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
        this.isLatestPatch = builder.isLatestPatch;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.registeredTime = builder.registeredTime;
    }

    /**
     * <p>
     * The account ID of the version's owner.
     * </p>
     * 
     * @return The account ID of the version's owner.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The version's ID.
     * </p>
     * 
     * @return The version's ID.
     */
    public final String packageId() {
        return packageId;
    }

    /**
     * <p>
     * The ARN of the package.
     * </p>
     * 
     * @return The ARN of the package.
     */
    public final String packageArn() {
        return packageArn;
    }

    /**
     * <p>
     * The version's name.
     * </p>
     * 
     * @return The version's name.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The version's version.
     * </p>
     * 
     * @return The version's version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The version's patch version.
     * </p>
     * 
     * @return The version's patch version.
     */
    public final String patchVersion() {
        return patchVersion;
    }

    /**
     * <p>
     * Whether the version is the latest available.
     * </p>
     * 
     * @return Whether the version is the latest available.
     */
    public final Boolean isLatestPatch() {
        return isLatestPatch;
    }

    /**
     * <p>
     * The version's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The version's status.
     * @see PackageVersionStatus
     */
    public final PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The version's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The version's status.
     * @see PackageVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The version's status description.
     * </p>
     * 
     * @return The version's status description.
     */
    public final String statusDescription() {
        return statusDescription;
    }

    /**
     * <p>
     * The version's registered time.
     * </p>
     * 
     * @return The version's registered time.
     */
    public final Instant registeredTime() {
        return registeredTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(packageId());
        hashCode = 31 * hashCode + Objects.hashCode(packageArn());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(patchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(isLatestPatch());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(registeredTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageVersionResponse)) {
            return false;
        }
        DescribePackageVersionResponse other = (DescribePackageVersionResponse) obj;
        return Objects.equals(ownerAccount(), other.ownerAccount()) && Objects.equals(packageId(), other.packageId())
                && Objects.equals(packageArn(), other.packageArn()) && Objects.equals(packageName(), other.packageName())
                && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(patchVersion(), other.patchVersion()) && Objects.equals(isLatestPatch(), other.isLatestPatch())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDescription(), other.statusDescription())
                && Objects.equals(registeredTime(), other.registeredTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePackageVersionResponse").add("OwnerAccount", ownerAccount())
                .add("PackageId", packageId()).add("PackageArn", packageArn()).add("PackageName", packageName())
                .add("PackageVersion", packageVersion()).add("PatchVersion", patchVersion())
                .add("IsLatestPatch", isLatestPatch()).add("Status", statusAsString())
                .add("StatusDescription", statusDescription()).add("RegisteredTime", registeredTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "PackageId":
            return Optional.ofNullable(clazz.cast(packageId()));
        case "PackageArn":
            return Optional.ofNullable(clazz.cast(packageArn()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "PatchVersion":
            return Optional.ofNullable(clazz.cast(patchVersion()));
        case "IsLatestPatch":
            return Optional.ofNullable(clazz.cast(isLatestPatch()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDescription":
            return Optional.ofNullable(clazz.cast(statusDescription()));
        case "RegisteredTime":
            return Optional.ofNullable(clazz.cast(registeredTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageVersionResponse, T> g) {
        return obj -> g.apply((DescribePackageVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePackageVersionResponse> {
        /**
         * <p>
         * The account ID of the version's owner.
         * </p>
         * 
         * @param ownerAccount
         *        The account ID of the version's owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The version's ID.
         * </p>
         * 
         * @param packageId
         *        The version's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageId(String packageId);

        /**
         * <p>
         * The ARN of the package.
         * </p>
         * 
         * @param packageArn
         *        The ARN of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageArn(String packageArn);

        /**
         * <p>
         * The version's name.
         * </p>
         * 
         * @param packageName
         *        The version's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The version's version.
         * </p>
         * 
         * @param packageVersion
         *        The version's version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The version's patch version.
         * </p>
         * 
         * @param patchVersion
         *        The version's patch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchVersion(String patchVersion);

        /**
         * <p>
         * Whether the version is the latest available.
         * </p>
         * 
         * @param isLatestPatch
         *        Whether the version is the latest available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLatestPatch(Boolean isLatestPatch);

        /**
         * <p>
         * The version's status.
         * </p>
         * 
         * @param status
         *        The version's status.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The version's status.
         * </p>
         * 
         * @param status
         *        The version's status.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(PackageVersionStatus status);

        /**
         * <p>
         * The version's status description.
         * </p>
         * 
         * @param statusDescription
         *        The version's status description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDescription(String statusDescription);

        /**
         * <p>
         * The version's registered time.
         * </p>
         * 
         * @param registeredTime
         *        The version's registered time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredTime(Instant registeredTime);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String ownerAccount;

        private String packageId;

        private String packageArn;

        private String packageName;

        private String packageVersion;

        private String patchVersion;

        private Boolean isLatestPatch;

        private String status;

        private String statusDescription;

        private Instant registeredTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageVersionResponse model) {
            super(model);
            ownerAccount(model.ownerAccount);
            packageId(model.packageId);
            packageArn(model.packageArn);
            packageName(model.packageName);
            packageVersion(model.packageVersion);
            patchVersion(model.patchVersion);
            isLatestPatch(model.isLatestPatch);
            status(model.status);
            statusDescription(model.statusDescription);
            registeredTime(model.registeredTime);
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        @Transient
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageId() {
            return packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        @Transient
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageArn() {
            return packageArn;
        }

        public final void setPackageArn(String packageArn) {
            this.packageArn = packageArn;
        }

        @Override
        @Transient
        public final Builder packageArn(String packageArn) {
            this.packageArn = packageArn;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        @Transient
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        @Transient
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        public final Boolean getIsLatestPatch() {
            return isLatestPatch;
        }

        public final void setIsLatestPatch(Boolean isLatestPatch) {
            this.isLatestPatch = isLatestPatch;
        }

        @Override
        @Transient
        public final Builder isLatestPatch(Boolean isLatestPatch) {
            this.isLatestPatch = isLatestPatch;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDescription() {
            return statusDescription;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        @Override
        @Transient
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final Instant getRegisteredTime() {
            return registeredTime;
        }

        public final void setRegisteredTime(Instant registeredTime) {
            this.registeredTime = registeredTime;
        }

        @Override
        @Transient
        public final Builder registeredTime(Instant registeredTime) {
            this.registeredTime = registeredTime;
            return this;
        }

        @Override
        public DescribePackageVersionResponse build() {
            return new DescribePackageVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
