/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A device's Ethernet status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EthernetStatus implements SdkPojo, Serializable, ToCopyableBuilder<EthernetStatus.Builder, EthernetStatus> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(EthernetStatus::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionStatus").getter(getter(EthernetStatus::connectionStatusAsString))
            .setter(setter(Builder::connectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final SdkField<String> HW_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HwAddress").getter(getter(EthernetStatus::hwAddress)).setter(setter(Builder::hwAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HwAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD,
            CONNECTION_STATUS_FIELD, HW_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String connectionStatus;

    private final String hwAddress;

    private EthernetStatus(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.connectionStatus = builder.connectionStatus;
        this.hwAddress = builder.hwAddress;
    }

    /**
     * <p>
     * The device's IP address.
     * </p>
     * 
     * @return The device's IP address.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The device's connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link NetworkConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The device's connection status.
     * @see NetworkConnectionStatus
     */
    public final NetworkConnectionStatus connectionStatus() {
        return NetworkConnectionStatus.fromValue(connectionStatus);
    }

    /**
     * <p>
     * The device's connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link NetworkConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The device's connection status.
     * @see NetworkConnectionStatus
     */
    public final String connectionStatusAsString() {
        return connectionStatus;
    }

    /**
     * <p>
     * The device's physical address.
     * </p>
     * 
     * @return The device's physical address.
     */
    public final String hwAddress() {
        return hwAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hwAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EthernetStatus)) {
            return false;
        }
        EthernetStatus other = (EthernetStatus) obj;
        return Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(connectionStatusAsString(), other.connectionStatusAsString())
                && Objects.equals(hwAddress(), other.hwAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EthernetStatus").add("IpAddress", ipAddress())
                .add("ConnectionStatus", connectionStatusAsString()).add("HwAddress", hwAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatusAsString()));
        case "HwAddress":
            return Optional.ofNullable(clazz.cast(hwAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EthernetStatus, T> g) {
        return obj -> g.apply((EthernetStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EthernetStatus> {
        /**
         * <p>
         * The device's IP address.
         * </p>
         * 
         * @param ipAddress
         *        The device's IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The device's connection status.
         * </p>
         * 
         * @param connectionStatus
         *        The device's connection status.
         * @see NetworkConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkConnectionStatus
         */
        Builder connectionStatus(String connectionStatus);

        /**
         * <p>
         * The device's connection status.
         * </p>
         * 
         * @param connectionStatus
         *        The device's connection status.
         * @see NetworkConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkConnectionStatus
         */
        Builder connectionStatus(NetworkConnectionStatus connectionStatus);

        /**
         * <p>
         * The device's physical address.
         * </p>
         * 
         * @param hwAddress
         *        The device's physical address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hwAddress(String hwAddress);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String connectionStatus;

        private String hwAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(EthernetStatus model) {
            ipAddress(model.ipAddress);
            connectionStatus(model.connectionStatus);
            hwAddress(model.hwAddress);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        @Transient
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getConnectionStatus() {
            return connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        @Transient
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder connectionStatus(NetworkConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final String getHwAddress() {
            return hwAddress;
        }

        public final void setHwAddress(String hwAddress) {
            this.hwAddress = hwAddress;
        }

        @Override
        @Transient
        public final Builder hwAddress(String hwAddress) {
            this.hwAddress = hwAddress;
            return this;
        }

        @Override
        public EthernetStatus build() {
            return new EthernetStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
