/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationInstanceNodeInstancesResponse extends PanoramaResponse implements
        ToCopyableBuilder<ListApplicationInstanceNodeInstancesResponse.Builder, ListApplicationInstanceNodeInstancesResponse> {
    private static final SdkField<List<NodeInstance>> NODE_INSTANCES_FIELD = SdkField
            .<List<NodeInstance>> builder(MarshallingType.LIST)
            .memberName("NodeInstances")
            .getter(getter(ListApplicationInstanceNodeInstancesResponse::nodeInstances))
            .setter(setter(Builder::nodeInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationInstanceNodeInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NodeInstance> nodeInstances;

    private final String nextToken;

    private ListApplicationInstanceNodeInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nodeInstances = builder.nodeInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeInstances() {
        return nodeInstances != null && !(nodeInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeInstances} method.
     * </p>
     * 
     * @return A list of node instances.
     */
    public final List<NodeInstance> nodeInstances() {
        return nodeInstances;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeInstances() ? nodeInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationInstanceNodeInstancesResponse)) {
            return false;
        }
        ListApplicationInstanceNodeInstancesResponse other = (ListApplicationInstanceNodeInstancesResponse) obj;
        return hasNodeInstances() == other.hasNodeInstances() && Objects.equals(nodeInstances(), other.nodeInstances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationInstanceNodeInstancesResponse")
                .add("NodeInstances", hasNodeInstances() ? nodeInstances() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeInstances":
            return Optional.ofNullable(clazz.cast(nodeInstances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationInstanceNodeInstancesResponse, T> g) {
        return obj -> g.apply((ListApplicationInstanceNodeInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationInstanceNodeInstancesResponse> {
        /**
         * <p>
         * A list of node instances.
         * </p>
         * 
         * @param nodeInstances
         *        A list of node instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInstances(Collection<NodeInstance> nodeInstances);

        /**
         * <p>
         * A list of node instances.
         * </p>
         * 
         * @param nodeInstances
         *        A list of node instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInstances(NodeInstance... nodeInstances);

        /**
         * <p>
         * A list of node instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NodeInstance>.Builder} avoiding the need to
         * create one manually via {@link List<NodeInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeInstance>.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeInstances(List<NodeInstance>)}.
         * 
         * @param nodeInstances
         *        a consumer that will call methods on {@link List<NodeInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeInstances(List<NodeInstance>)
         */
        Builder nodeInstances(Consumer<NodeInstance.Builder>... nodeInstances);

        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private List<NodeInstance> nodeInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationInstanceNodeInstancesResponse model) {
            super(model);
            nodeInstances(model.nodeInstances);
            nextToken(model.nextToken);
        }

        public final List<NodeInstance.Builder> getNodeInstances() {
            List<NodeInstance.Builder> result = NodeInstancesCopier.copyToBuilder(this.nodeInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInstances(Collection<NodeInstance.BuilderImpl> nodeInstances) {
            this.nodeInstances = NodeInstancesCopier.copyFromBuilder(nodeInstances);
        }

        @Override
        @Transient
        public final Builder nodeInstances(Collection<NodeInstance> nodeInstances) {
            this.nodeInstances = NodeInstancesCopier.copy(nodeInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeInstances(NodeInstance... nodeInstances) {
            nodeInstances(Arrays.asList(nodeInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nodeInstances(Consumer<NodeInstance.Builder>... nodeInstances) {
            nodeInstances(Stream.of(nodeInstances).map(c -> NodeInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationInstanceNodeInstancesResponse build() {
            return new ListApplicationInstanceNodeInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
