/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Results of a package import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageImportJobOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageImportJobOutput.Builder, PackageImportJobOutput> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageId").getter(getter(PackageImportJobOutput::packageId)).setter(setter(Builder::packageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(PackageImportJobOutput::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchVersion").getter(getter(PackageImportJobOutput::patchVersion))
            .setter(setter(Builder::patchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()).build();

    private static final SdkField<OutPutS3Location> OUTPUT_S3_LOCATION_FIELD = SdkField
            .<OutPutS3Location> builder(MarshallingType.SDK_POJO).memberName("OutputS3Location")
            .getter(getter(PackageImportJobOutput::outputS3Location)).setter(setter(Builder::outputS3Location))
            .constructor(OutPutS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD, OUTPUT_S3_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String packageId;

    private final String packageVersion;

    private final String patchVersion;

    private final OutPutS3Location outputS3Location;

    private PackageImportJobOutput(BuilderImpl builder) {
        this.packageId = builder.packageId;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
        this.outputS3Location = builder.outputS3Location;
    }

    /**
     * <p>
     * The package's ID.
     * </p>
     * 
     * @return The package's ID.
     */
    public final String packageId() {
        return packageId;
    }

    /**
     * <p>
     * The package's version.
     * </p>
     * 
     * @return The package's version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The package's patch version.
     * </p>
     * 
     * @return The package's patch version.
     */
    public final String patchVersion() {
        return patchVersion;
    }

    /**
     * <p>
     * The package's output location.
     * </p>
     * 
     * @return The package's output location.
     */
    public final OutPutS3Location outputS3Location() {
        return outputS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageId());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(patchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(outputS3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageImportJobOutput)) {
            return false;
        }
        PackageImportJobOutput other = (PackageImportJobOutput) obj;
        return Objects.equals(packageId(), other.packageId()) && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(patchVersion(), other.patchVersion())
                && Objects.equals(outputS3Location(), other.outputS3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageImportJobOutput").add("PackageId", packageId()).add("PackageVersion", packageVersion())
                .add("PatchVersion", patchVersion()).add("OutputS3Location", outputS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageId":
            return Optional.ofNullable(clazz.cast(packageId()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "PatchVersion":
            return Optional.ofNullable(clazz.cast(patchVersion()));
        case "OutputS3Location":
            return Optional.ofNullable(clazz.cast(outputS3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageImportJobOutput, T> g) {
        return obj -> g.apply((PackageImportJobOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageImportJobOutput> {
        /**
         * <p>
         * The package's ID.
         * </p>
         * 
         * @param packageId
         *        The package's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageId(String packageId);

        /**
         * <p>
         * The package's version.
         * </p>
         * 
         * @param packageVersion
         *        The package's version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The package's patch version.
         * </p>
         * 
         * @param patchVersion
         *        The package's patch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchVersion(String patchVersion);

        /**
         * <p>
         * The package's output location.
         * </p>
         * 
         * @param outputS3Location
         *        The package's output location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Location(OutPutS3Location outputS3Location);

        /**
         * <p>
         * The package's output location.
         * </p>
         * This is a convenience that creates an instance of the {@link OutPutS3Location.Builder} avoiding the need to
         * create one manually via {@link OutPutS3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutPutS3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #outputS3Location(OutPutS3Location)}.
         * 
         * @param outputS3Location
         *        a consumer that will call methods on {@link OutPutS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputS3Location(OutPutS3Location)
         */
        default Builder outputS3Location(Consumer<OutPutS3Location.Builder> outputS3Location) {
            return outputS3Location(OutPutS3Location.builder().applyMutation(outputS3Location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String packageId;

        private String packageVersion;

        private String patchVersion;

        private OutPutS3Location outputS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageImportJobOutput model) {
            packageId(model.packageId);
            packageVersion(model.packageVersion);
            patchVersion(model.patchVersion);
            outputS3Location(model.outputS3Location);
        }

        public final String getPackageId() {
            return packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        @Transient
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        @Transient
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        public final OutPutS3Location.Builder getOutputS3Location() {
            return outputS3Location != null ? outputS3Location.toBuilder() : null;
        }

        public final void setOutputS3Location(OutPutS3Location.BuilderImpl outputS3Location) {
            this.outputS3Location = outputS3Location != null ? outputS3Location.build() : null;
        }

        @Override
        @Transient
        public final Builder outputS3Location(OutPutS3Location outputS3Location) {
            this.outputS3Location = outputS3Location;
            return this;
        }

        @Override
        public PackageImportJobOutput build() {
            return new PackageImportJobOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
