/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A package version output configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageVersionOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageVersionOutputConfig.Builder, PackageVersionOutputConfig> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(PackageVersionOutputConfig::packageName))
            .setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(PackageVersionOutputConfig::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<Boolean> MARK_LATEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MarkLatest").getter(getter(PackageVersionOutputConfig::markLatest)).setter(setter(Builder::markLatest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarkLatest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            PACKAGE_VERSION_FIELD, MARK_LATEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String packageName;

    private final String packageVersion;

    private final Boolean markLatest;

    private PackageVersionOutputConfig(BuilderImpl builder) {
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.markLatest = builder.markLatest;
    }

    /**
     * <p>
     * The output's package name.
     * </p>
     * 
     * @return The output's package name.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The output's package version.
     * </p>
     * 
     * @return The output's package version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * Indicates that the version is recommended for all users.
     * </p>
     * 
     * @return Indicates that the version is recommended for all users.
     */
    public final Boolean markLatest() {
        return markLatest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(markLatest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVersionOutputConfig)) {
            return false;
        }
        PackageVersionOutputConfig other = (PackageVersionOutputConfig) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(markLatest(), other.markLatest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageVersionOutputConfig").add("PackageName", packageName())
                .add("PackageVersion", packageVersion()).add("MarkLatest", markLatest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "MarkLatest":
            return Optional.ofNullable(clazz.cast(markLatest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageVersionOutputConfig, T> g) {
        return obj -> g.apply((PackageVersionOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageVersionOutputConfig> {
        /**
         * <p>
         * The output's package name.
         * </p>
         * 
         * @param packageName
         *        The output's package name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The output's package version.
         * </p>
         * 
         * @param packageVersion
         *        The output's package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * Indicates that the version is recommended for all users.
         * </p>
         * 
         * @param markLatest
         *        Indicates that the version is recommended for all users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder markLatest(Boolean markLatest);
    }

    static final class BuilderImpl implements Builder {
        private String packageName;

        private String packageVersion;

        private Boolean markLatest;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVersionOutputConfig model) {
            packageName(model.packageName);
            packageVersion(model.packageVersion);
            markLatest(model.markLatest);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        @Transient
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final Boolean getMarkLatest() {
            return markLatest;
        }

        public final void setMarkLatest(Boolean markLatest) {
            this.markLatest = markLatest;
        }

        @Override
        @Transient
        public final Builder markLatest(Boolean markLatest) {
            this.markLatest = markLatest;
            return this;
        }

        @Override
        public PackageVersionOutputConfig build() {
            return new PackageVersionOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
