/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A location in Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Location implements SdkPojo, Serializable, ToCopyableBuilder<S3Location.Builder, S3Location> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(S3Location::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(S3Location::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectKey").getter(getter(S3Location::objectKey)).setter(setter(Builder::objectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            BUCKET_NAME_FIELD, OBJECT_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String bucketName;

    private final String objectKey;

    private S3Location(BuilderImpl builder) {
        this.region = builder.region;
        this.bucketName = builder.bucketName;
        this.objectKey = builder.objectKey;
    }

    /**
     * <p>
     * The bucket's Region.
     * </p>
     * 
     * @return The bucket's Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * A bucket name.
     * </p>
     * 
     * @return A bucket name.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * An object key.
     * </p>
     * 
     * @return An object key.
     */
    public final String objectKey() {
        return objectKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(objectKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(objectKey(), other.objectKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Location").add("Region", region()).add("BucketName", bucketName())
                .add("ObjectKey", objectKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "ObjectKey":
            return Optional.ofNullable(clazz.cast(objectKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Location, T> g) {
        return obj -> g.apply((S3Location) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Location> {
        /**
         * <p>
         * The bucket's Region.
         * </p>
         * 
         * @param region
         *        The bucket's Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * A bucket name.
         * </p>
         * 
         * @param bucketName
         *        A bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * An object key.
         * </p>
         * 
         * @param objectKey
         *        An object key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKey(String objectKey);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String bucketName;

        private String objectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            region(model.region);
            bucketName(model.bucketName);
            objectKey(model.objectKey);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getObjectKey() {
            return objectKey;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        @Transient
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        @Override
        public S3Location build() {
            return new S3Location(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
