/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.services.panorama.model.PrincipalArnsListCopier;
import software.amazon.awssdk.services.panorama.model.StorageLocation;
import software.amazon.awssdk.services.panorama.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePackageResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, DescribePackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribePackageResponse.getter(DescribePackageResponse::arn)).setter(DescribePackageResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribePackageResponse.getter(DescribePackageResponse::createdTime)).setter(DescribePackageResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageId").getter(DescribePackageResponse.getter(DescribePackageResponse::packageId)).setter(DescribePackageResponse.setter(Builder::packageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(DescribePackageResponse.getter(DescribePackageResponse::packageName)).setter(DescribePackageResponse.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<List<String>> READ_ACCESS_PRINCIPAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadAccessPrincipalArns").getter(DescribePackageResponse.getter(DescribePackageResponse::readAccessPrincipalArns)).setter(DescribePackageResponse.setter(Builder::readAccessPrincipalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAccessPrincipalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StorageLocation> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageLocation").getter(DescribePackageResponse.getter(DescribePackageResponse::storageLocation)).setter(DescribePackageResponse.setter(Builder::storageLocation)).constructor(StorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribePackageResponse.getter(DescribePackageResponse::tags)).setter(DescribePackageResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WRITE_ACCESS_PRINCIPAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WriteAccessPrincipalArns").getter(DescribePackageResponse.getter(DescribePackageResponse::writeAccessPrincipalArns)).setter(DescribePackageResponse.setter(Builder::writeAccessPrincipalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WriteAccessPrincipalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_TIME_FIELD, PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, READ_ACCESS_PRINCIPAL_ARNS_FIELD, STORAGE_LOCATION_FIELD, TAGS_FIELD, WRITE_ACCESS_PRINCIPAL_ARNS_FIELD));
    private final String arn;
    private final Instant createdTime;
    private final String packageId;
    private final String packageName;
    private final List<String> readAccessPrincipalArns;
    private final StorageLocation storageLocation;
    private final Map<String, String> tags;
    private final List<String> writeAccessPrincipalArns;

    private DescribePackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.packageId = builder.packageId;
        this.packageName = builder.packageName;
        this.readAccessPrincipalArns = builder.readAccessPrincipalArns;
        this.storageLocation = builder.storageLocation;
        this.tags = builder.tags;
        this.writeAccessPrincipalArns = builder.writeAccessPrincipalArns;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String packageId() {
        return this.packageId;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final boolean hasReadAccessPrincipalArns() {
        return this.readAccessPrincipalArns != null && !(this.readAccessPrincipalArns instanceof SdkAutoConstructList);
    }

    public final List<String> readAccessPrincipalArns() {
        return this.readAccessPrincipalArns;
    }

    public final StorageLocation storageLocation() {
        return this.storageLocation;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasWriteAccessPrincipalArns() {
        return this.writeAccessPrincipalArns != null && !(this.writeAccessPrincipalArns instanceof SdkAutoConstructList);
    }

    public final List<String> writeAccessPrincipalArns() {
        return this.writeAccessPrincipalArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadAccessPrincipalArns() ? this.readAccessPrincipalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWriteAccessPrincipalArns() ? this.writeAccessPrincipalArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageResponse)) {
            return false;
        }
        DescribePackageResponse other = (DescribePackageResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.packageId(), other.packageId()) && Objects.equals(this.packageName(), other.packageName()) && this.hasReadAccessPrincipalArns() == other.hasReadAccessPrincipalArns() && Objects.equals(this.readAccessPrincipalArns(), other.readAccessPrincipalArns()) && Objects.equals(this.storageLocation(), other.storageLocation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasWriteAccessPrincipalArns() == other.hasWriteAccessPrincipalArns() && Objects.equals(this.writeAccessPrincipalArns(), other.writeAccessPrincipalArns());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePackageResponse").add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("PackageId", (Object)this.packageId()).add("PackageName", (Object)this.packageName()).add("ReadAccessPrincipalArns", this.hasReadAccessPrincipalArns() ? this.readAccessPrincipalArns() : null).add("StorageLocation", (Object)this.storageLocation()).add("Tags", this.hasTags() ? this.tags() : null).add("WriteAccessPrincipalArns", this.hasWriteAccessPrincipalArns() ? this.writeAccessPrincipalArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "PackageId": {
                return Optional.ofNullable(clazz.cast(this.packageId()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "ReadAccessPrincipalArns": {
                return Optional.ofNullable(clazz.cast(this.readAccessPrincipalArns()));
            }
            case "StorageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WriteAccessPrincipalArns": {
                return Optional.ofNullable(clazz.cast(this.writeAccessPrincipalArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageResponse, T> g) {
        return obj -> g.apply((DescribePackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdTime;
        private String packageId;
        private String packageName;
        private List<String> readAccessPrincipalArns = DefaultSdkAutoConstructList.getInstance();
        private StorageLocation storageLocation;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> writeAccessPrincipalArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.packageId(model.packageId);
            this.packageName(model.packageName);
            this.readAccessPrincipalArns(model.readAccessPrincipalArns);
            this.storageLocation(model.storageLocation);
            this.tags(model.tags);
            this.writeAccessPrincipalArns(model.writeAccessPrincipalArns);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getPackageId() {
            return this.packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        @Transient
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        @Transient
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final Collection<String> getReadAccessPrincipalArns() {
            if (this.readAccessPrincipalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readAccessPrincipalArns;
        }

        public final void setReadAccessPrincipalArns(Collection<String> readAccessPrincipalArns) {
            this.readAccessPrincipalArns = PrincipalArnsListCopier.copy(readAccessPrincipalArns);
        }

        @Override
        @Transient
        public final Builder readAccessPrincipalArns(Collection<String> readAccessPrincipalArns) {
            this.readAccessPrincipalArns = PrincipalArnsListCopier.copy(readAccessPrincipalArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder readAccessPrincipalArns(String ... readAccessPrincipalArns) {
            this.readAccessPrincipalArns(Arrays.asList(readAccessPrincipalArns));
            return this;
        }

        public final StorageLocation.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(StorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder storageLocation(StorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getWriteAccessPrincipalArns() {
            if (this.writeAccessPrincipalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.writeAccessPrincipalArns;
        }

        public final void setWriteAccessPrincipalArns(Collection<String> writeAccessPrincipalArns) {
            this.writeAccessPrincipalArns = PrincipalArnsListCopier.copy(writeAccessPrincipalArns);
        }

        @Override
        @Transient
        public final Builder writeAccessPrincipalArns(Collection<String> writeAccessPrincipalArns) {
            this.writeAccessPrincipalArns = PrincipalArnsListCopier.copy(writeAccessPrincipalArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder writeAccessPrincipalArns(String ... writeAccessPrincipalArns) {
            this.writeAccessPrincipalArns(Arrays.asList(writeAccessPrincipalArns));
            return this;
        }

        @Override
        public DescribePackageResponse build() {
            return new DescribePackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePackageResponse> {
        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder packageId(String var1);

        public Builder packageName(String var1);

        public Builder readAccessPrincipalArns(Collection<String> var1);

        public Builder readAccessPrincipalArns(String ... var1);

        public Builder storageLocation(StorageLocation var1);

        default public Builder storageLocation(Consumer<StorageLocation.Builder> storageLocation) {
            return this.storageLocation((StorageLocation)((StorageLocation.Builder)StorageLocation.builder().applyMutation(storageLocation)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder writeAccessPrincipalArns(Collection<String> var1);

        public Builder writeAccessPrincipalArns(String ... var1);
    }
}

