/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationInstanceDetailsResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribeApplicationInstanceDetailsResponse.Builder, DescribeApplicationInstanceDetailsResponse> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationInstanceId")
            .getter(getter(DescribeApplicationInstanceDetailsResponse::applicationInstanceId))
            .setter(setter(Builder::applicationInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceId").build())
            .build();

    private static final SdkField<String> APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationInstanceIdToReplace")
            .getter(getter(DescribeApplicationInstanceDetailsResponse::applicationInstanceIdToReplace))
            .setter(setter(Builder::applicationInstanceIdToReplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceIdToReplace")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeApplicationInstanceDetailsResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRuntimeContextDevice")
            .getter(getter(DescribeApplicationInstanceDetailsResponse::defaultRuntimeContextDevice))
            .setter(setter(Builder::defaultRuntimeContextDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDevice")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeApplicationInstanceDetailsResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ManifestOverridesPayload> MANIFEST_OVERRIDES_PAYLOAD_FIELD = SdkField
            .<ManifestOverridesPayload> builder(MarshallingType.SDK_POJO).memberName("ManifestOverridesPayload")
            .getter(getter(DescribeApplicationInstanceDetailsResponse::manifestOverridesPayload))
            .setter(setter(Builder::manifestOverridesPayload)).constructor(ManifestOverridesPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestOverridesPayload").build())
            .build();

    private static final SdkField<ManifestPayload> MANIFEST_PAYLOAD_FIELD = SdkField
            .<ManifestPayload> builder(MarshallingType.SDK_POJO).memberName("ManifestPayload")
            .getter(getter(DescribeApplicationInstanceDetailsResponse::manifestPayload)).setter(setter(Builder::manifestPayload))
            .constructor(ManifestPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestPayload").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeApplicationInstanceDetailsResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_FIELD,
            APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD, CREATED_TIME_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD,
            DESCRIPTION_FIELD, MANIFEST_OVERRIDES_PAYLOAD_FIELD, MANIFEST_PAYLOAD_FIELD, NAME_FIELD));

    private final String applicationInstanceId;

    private final String applicationInstanceIdToReplace;

    private final Instant createdTime;

    private final String defaultRuntimeContextDevice;

    private final String description;

    private final ManifestOverridesPayload manifestOverridesPayload;

    private final ManifestPayload manifestPayload;

    private final String name;

    private DescribeApplicationInstanceDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceId = builder.applicationInstanceId;
        this.applicationInstanceIdToReplace = builder.applicationInstanceIdToReplace;
        this.createdTime = builder.createdTime;
        this.defaultRuntimeContextDevice = builder.defaultRuntimeContextDevice;
        this.description = builder.description;
        this.manifestOverridesPayload = builder.manifestOverridesPayload;
        this.manifestPayload = builder.manifestPayload;
        this.name = builder.name;
    }

    /**
     * <p>
     * The application instance's ID.
     * </p>
     * 
     * @return The application instance's ID.
     */
    public final String applicationInstanceId() {
        return applicationInstanceId;
    }

    /**
     * <p>
     * The ID of the application instance that this instance replaced.
     * </p>
     * 
     * @return The ID of the application instance that this instance replaced.
     */
    public final String applicationInstanceIdToReplace() {
        return applicationInstanceIdToReplace;
    }

    /**
     * <p>
     * When the application instance was created.
     * </p>
     * 
     * @return When the application instance was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The application instance's default runtime context device.
     * </p>
     * 
     * @return The application instance's default runtime context device.
     */
    public final String defaultRuntimeContextDevice() {
        return defaultRuntimeContextDevice;
    }

    /**
     * <p>
     * The application instance's description.
     * </p>
     * 
     * @return The application instance's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Parameter overrides for the configuration manifest.
     * </p>
     * 
     * @return Parameter overrides for the configuration manifest.
     */
    public final ManifestOverridesPayload manifestOverridesPayload() {
        return manifestOverridesPayload;
    }

    /**
     * <p>
     * The application instance's configuration manifest.
     * </p>
     * 
     * @return The application instance's configuration manifest.
     */
    public final ManifestPayload manifestPayload() {
        return manifestPayload;
    }

    /**
     * <p>
     * The application instance's name.
     * </p>
     * 
     * @return The application instance's name.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationInstanceIdToReplace());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRuntimeContextDevice());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(manifestOverridesPayload());
        hashCode = 31 * hashCode + Objects.hashCode(manifestPayload());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationInstanceDetailsResponse)) {
            return false;
        }
        DescribeApplicationInstanceDetailsResponse other = (DescribeApplicationInstanceDetailsResponse) obj;
        return Objects.equals(applicationInstanceId(), other.applicationInstanceId())
                && Objects.equals(applicationInstanceIdToReplace(), other.applicationInstanceIdToReplace())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(defaultRuntimeContextDevice(), other.defaultRuntimeContextDevice())
                && Objects.equals(description(), other.description())
                && Objects.equals(manifestOverridesPayload(), other.manifestOverridesPayload())
                && Objects.equals(manifestPayload(), other.manifestPayload()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationInstanceDetailsResponse")
                .add("ApplicationInstanceId", applicationInstanceId())
                .add("ApplicationInstanceIdToReplace", applicationInstanceIdToReplace()).add("CreatedTime", createdTime())
                .add("DefaultRuntimeContextDevice", defaultRuntimeContextDevice()).add("Description", description())
                .add("ManifestOverridesPayload", manifestOverridesPayload()).add("ManifestPayload", manifestPayload())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationInstanceId":
            return Optional.ofNullable(clazz.cast(applicationInstanceId()));
        case "ApplicationInstanceIdToReplace":
            return Optional.ofNullable(clazz.cast(applicationInstanceIdToReplace()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DefaultRuntimeContextDevice":
            return Optional.ofNullable(clazz.cast(defaultRuntimeContextDevice()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ManifestOverridesPayload":
            return Optional.ofNullable(clazz.cast(manifestOverridesPayload()));
        case "ManifestPayload":
            return Optional.ofNullable(clazz.cast(manifestPayload()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationInstanceDetailsResponse, T> g) {
        return obj -> g.apply((DescribeApplicationInstanceDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationInstanceDetailsResponse> {
        /**
         * <p>
         * The application instance's ID.
         * </p>
         * 
         * @param applicationInstanceId
         *        The application instance's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInstanceId(String applicationInstanceId);

        /**
         * <p>
         * The ID of the application instance that this instance replaced.
         * </p>
         * 
         * @param applicationInstanceIdToReplace
         *        The ID of the application instance that this instance replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace);

        /**
         * <p>
         * When the application instance was created.
         * </p>
         * 
         * @param createdTime
         *        When the application instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The application instance's default runtime context device.
         * </p>
         * 
         * @param defaultRuntimeContextDevice
         *        The application instance's default runtime context device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice);

        /**
         * <p>
         * The application instance's description.
         * </p>
         * 
         * @param description
         *        The application instance's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Parameter overrides for the configuration manifest.
         * </p>
         * 
         * @param manifestOverridesPayload
         *        Parameter overrides for the configuration manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestOverridesPayload(ManifestOverridesPayload manifestOverridesPayload);

        /**
         * <p>
         * Parameter overrides for the configuration manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestOverridesPayload.Builder}
         * avoiding the need to create one manually via {@link ManifestOverridesPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManifestOverridesPayload.Builder#build()} is called immediately
         * and its result is passed to {@link #manifestOverridesPayload(ManifestOverridesPayload)}.
         * 
         * @param manifestOverridesPayload
         *        a consumer that will call methods on {@link ManifestOverridesPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestOverridesPayload(ManifestOverridesPayload)
         */
        default Builder manifestOverridesPayload(Consumer<ManifestOverridesPayload.Builder> manifestOverridesPayload) {
            return manifestOverridesPayload(ManifestOverridesPayload.builder().applyMutation(manifestOverridesPayload).build());
        }

        /**
         * <p>
         * The application instance's configuration manifest.
         * </p>
         * 
         * @param manifestPayload
         *        The application instance's configuration manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestPayload(ManifestPayload manifestPayload);

        /**
         * <p>
         * The application instance's configuration manifest.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestPayload.Builder} avoiding the
         * need to create one manually via {@link ManifestPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManifestPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #manifestPayload(ManifestPayload)}.
         * 
         * @param manifestPayload
         *        a consumer that will call methods on {@link ManifestPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestPayload(ManifestPayload)
         */
        default Builder manifestPayload(Consumer<ManifestPayload.Builder> manifestPayload) {
            return manifestPayload(ManifestPayload.builder().applyMutation(manifestPayload).build());
        }

        /**
         * <p>
         * The application instance's name.
         * </p>
         * 
         * @param name
         *        The application instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String applicationInstanceId;

        private String applicationInstanceIdToReplace;

        private Instant createdTime;

        private String defaultRuntimeContextDevice;

        private String description;

        private ManifestOverridesPayload manifestOverridesPayload;

        private ManifestPayload manifestPayload;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationInstanceDetailsResponse model) {
            super(model);
            applicationInstanceId(model.applicationInstanceId);
            applicationInstanceIdToReplace(model.applicationInstanceIdToReplace);
            createdTime(model.createdTime);
            defaultRuntimeContextDevice(model.defaultRuntimeContextDevice);
            description(model.description);
            manifestOverridesPayload(model.manifestOverridesPayload);
            manifestPayload(model.manifestPayload);
            name(model.name);
        }

        public final String getApplicationInstanceId() {
            return applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        public final String getApplicationInstanceIdToReplace() {
            return applicationInstanceIdToReplace;
        }

        public final void setApplicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
        }

        @Override
        public final Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDefaultRuntimeContextDevice() {
            return defaultRuntimeContextDevice;
        }

        public final void setDefaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
        }

        @Override
        public final Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ManifestOverridesPayload.Builder getManifestOverridesPayload() {
            return manifestOverridesPayload != null ? manifestOverridesPayload.toBuilder() : null;
        }

        public final void setManifestOverridesPayload(ManifestOverridesPayload.BuilderImpl manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload != null ? manifestOverridesPayload.build() : null;
        }

        @Override
        public final Builder manifestOverridesPayload(ManifestOverridesPayload manifestOverridesPayload) {
            this.manifestOverridesPayload = manifestOverridesPayload;
            return this;
        }

        public final ManifestPayload.Builder getManifestPayload() {
            return manifestPayload != null ? manifestPayload.toBuilder() : null;
        }

        public final void setManifestPayload(ManifestPayload.BuilderImpl manifestPayload) {
            this.manifestPayload = manifestPayload != null ? manifestPayload.build() : null;
        }

        @Override
        public final Builder manifestPayload(ManifestPayload manifestPayload) {
            this.manifestPayload = manifestPayload;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public DescribeApplicationInstanceDetailsResponse build() {
            return new DescribeApplicationInstanceDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
