/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNodeFromTemplateJobsResponse extends PanoramaResponse implements
        ToCopyableBuilder<ListNodeFromTemplateJobsResponse.Builder, ListNodeFromTemplateJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNodeFromTemplateJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<NodeFromTemplateJob>> NODE_FROM_TEMPLATE_JOBS_FIELD = SdkField
            .<List<NodeFromTemplateJob>> builder(MarshallingType.LIST)
            .memberName("NodeFromTemplateJobs")
            .getter(getter(ListNodeFromTemplateJobsResponse::nodeFromTemplateJobs))
            .setter(setter(Builder::nodeFromTemplateJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeFromTemplateJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeFromTemplateJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeFromTemplateJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NODE_FROM_TEMPLATE_JOBS_FIELD));

    private final String nextToken;

    private final List<NodeFromTemplateJob> nodeFromTemplateJobs;

    private ListNodeFromTemplateJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.nodeFromTemplateJobs = builder.nodeFromTemplateJobs;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeFromTemplateJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeFromTemplateJobs() {
        return nodeFromTemplateJobs != null && !(nodeFromTemplateJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeFromTemplateJobs} method.
     * </p>
     * 
     * @return A list of jobs.
     */
    public final List<NodeFromTemplateJob> nodeFromTemplateJobs() {
        return nodeFromTemplateJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeFromTemplateJobs() ? nodeFromTemplateJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodeFromTemplateJobsResponse)) {
            return false;
        }
        ListNodeFromTemplateJobsResponse other = (ListNodeFromTemplateJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasNodeFromTemplateJobs() == other.hasNodeFromTemplateJobs()
                && Objects.equals(nodeFromTemplateJobs(), other.nodeFromTemplateJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNodeFromTemplateJobsResponse").add("NextToken", nextToken())
                .add("NodeFromTemplateJobs", hasNodeFromTemplateJobs() ? nodeFromTemplateJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NodeFromTemplateJobs":
            return Optional.ofNullable(clazz.cast(nodeFromTemplateJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNodeFromTemplateJobsResponse, T> g) {
        return obj -> g.apply((ListNodeFromTemplateJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNodeFromTemplateJobsResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param nodeFromTemplateJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeFromTemplateJobs(Collection<NodeFromTemplateJob> nodeFromTemplateJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param nodeFromTemplateJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeFromTemplateJobs(NodeFromTemplateJob... nodeFromTemplateJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NodeFromTemplateJob>.Builder}
         * avoiding the need to create one manually via {@link List<NodeFromTemplateJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeFromTemplateJob>.Builder#build()} is called immediately
         * and its result is passed to {@link #nodeFromTemplateJobs(List<NodeFromTemplateJob>)}.
         * 
         * @param nodeFromTemplateJobs
         *        a consumer that will call methods on {@link List<NodeFromTemplateJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeFromTemplateJobs(List<NodeFromTemplateJob>)
         */
        Builder nodeFromTemplateJobs(Consumer<NodeFromTemplateJob.Builder>... nodeFromTemplateJobs);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NodeFromTemplateJob> nodeFromTemplateJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodeFromTemplateJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            nodeFromTemplateJobs(model.nodeFromTemplateJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NodeFromTemplateJob.Builder> getNodeFromTemplateJobs() {
            List<NodeFromTemplateJob.Builder> result = NodeFromTemplateJobListCopier.copyToBuilder(this.nodeFromTemplateJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeFromTemplateJobs(Collection<NodeFromTemplateJob.BuilderImpl> nodeFromTemplateJobs) {
            this.nodeFromTemplateJobs = NodeFromTemplateJobListCopier.copyFromBuilder(nodeFromTemplateJobs);
        }

        @Override
        public final Builder nodeFromTemplateJobs(Collection<NodeFromTemplateJob> nodeFromTemplateJobs) {
            this.nodeFromTemplateJobs = NodeFromTemplateJobListCopier.copy(nodeFromTemplateJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeFromTemplateJobs(NodeFromTemplateJob... nodeFromTemplateJobs) {
            nodeFromTemplateJobs(Arrays.asList(nodeFromTemplateJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeFromTemplateJobs(Consumer<NodeFromTemplateJob.Builder>... nodeFromTemplateJobs) {
            nodeFromTemplateJobs(Stream.of(nodeFromTemplateJobs).map(c -> NodeFromTemplateJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNodeFromTemplateJobsResponse build() {
            return new ListNodeFromTemplateJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
