/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationInstanceResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribeApplicationInstanceResponse.Builder, DescribeApplicationInstanceResponse> {
    private static final SdkField<String> APPLICATION_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationInstanceId").getter(getter(DescribeApplicationInstanceResponse::applicationInstanceId))
            .setter(setter(Builder::applicationInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceId").build())
            .build();

    private static final SdkField<String> APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationInstanceIdToReplace")
            .getter(getter(DescribeApplicationInstanceResponse::applicationInstanceIdToReplace))
            .setter(setter(Builder::applicationInstanceIdToReplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstanceIdToReplace")
                    .build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeApplicationInstanceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeApplicationInstanceResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRuntimeContextDevice")
            .getter(getter(DescribeApplicationInstanceResponse::defaultRuntimeContextDevice))
            .setter(setter(Builder::defaultRuntimeContextDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDevice")
                    .build()).build();

    private static final SdkField<String> DEFAULT_RUNTIME_CONTEXT_DEVICE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRuntimeContextDeviceName")
            .getter(getter(DescribeApplicationInstanceResponse::defaultRuntimeContextDeviceName))
            .setter(setter(Builder::defaultRuntimeContextDeviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRuntimeContextDeviceName")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeApplicationInstanceResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthStatus").getter(getter(DescribeApplicationInstanceResponse::healthStatusAsString))
            .setter(setter(Builder::healthStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeApplicationInstanceResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeApplicationInstanceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RUNTIME_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeRoleArn").getter(getter(DescribeApplicationInstanceResponse::runtimeRoleArn))
            .setter(setter(Builder::runtimeRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeRoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeApplicationInstanceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDescription").getter(getter(DescribeApplicationInstanceResponse::statusDescription))
            .setter(setter(Builder::statusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDescription").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeApplicationInstanceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCE_ID_FIELD,
            APPLICATION_INSTANCE_ID_TO_REPLACE_FIELD, ARN_FIELD, CREATED_TIME_FIELD, DEFAULT_RUNTIME_CONTEXT_DEVICE_FIELD,
            DEFAULT_RUNTIME_CONTEXT_DEVICE_NAME_FIELD, DESCRIPTION_FIELD, HEALTH_STATUS_FIELD, LAST_UPDATED_TIME_FIELD,
            NAME_FIELD, RUNTIME_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_DESCRIPTION_FIELD, TAGS_FIELD));

    private final String applicationInstanceId;

    private final String applicationInstanceIdToReplace;

    private final String arn;

    private final Instant createdTime;

    private final String defaultRuntimeContextDevice;

    private final String defaultRuntimeContextDeviceName;

    private final String description;

    private final String healthStatus;

    private final Instant lastUpdatedTime;

    private final String name;

    private final String runtimeRoleArn;

    private final String status;

    private final String statusDescription;

    private final Map<String, String> tags;

    private DescribeApplicationInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInstanceId = builder.applicationInstanceId;
        this.applicationInstanceIdToReplace = builder.applicationInstanceIdToReplace;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.defaultRuntimeContextDevice = builder.defaultRuntimeContextDevice;
        this.defaultRuntimeContextDeviceName = builder.defaultRuntimeContextDeviceName;
        this.description = builder.description;
        this.healthStatus = builder.healthStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.name = builder.name;
        this.runtimeRoleArn = builder.runtimeRoleArn;
        this.status = builder.status;
        this.statusDescription = builder.statusDescription;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The application instance's ID.
     * </p>
     * 
     * @return The application instance's ID.
     */
    public final String applicationInstanceId() {
        return applicationInstanceId;
    }

    /**
     * <p>
     * The ID of the application instance that this instance replaced.
     * </p>
     * 
     * @return The ID of the application instance that this instance replaced.
     */
    public final String applicationInstanceIdToReplace() {
        return applicationInstanceIdToReplace;
    }

    /**
     * <p>
     * The application instance's ARN.
     * </p>
     * 
     * @return The application instance's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When the application instance was created.
     * </p>
     * 
     * @return When the application instance was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The device's ID.
     * </p>
     * 
     * @return The device's ID.
     */
    public final String defaultRuntimeContextDevice() {
        return defaultRuntimeContextDevice;
    }

    /**
     * <p>
     * The device's bane.
     * </p>
     * 
     * @return The device's bane.
     */
    public final String defaultRuntimeContextDeviceName() {
        return defaultRuntimeContextDeviceName;
    }

    /**
     * <p>
     * The application instance's description.
     * </p>
     * 
     * @return The application instance's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The application instance's health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link ApplicationInstanceHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The application instance's health status.
     * @see ApplicationInstanceHealthStatus
     */
    public final ApplicationInstanceHealthStatus healthStatus() {
        return ApplicationInstanceHealthStatus.fromValue(healthStatus);
    }

    /**
     * <p>
     * The application instance's health status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #healthStatus} will
     * return {@link ApplicationInstanceHealthStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #healthStatusAsString}.
     * </p>
     * 
     * @return The application instance's health status.
     * @see ApplicationInstanceHealthStatus
     */
    public final String healthStatusAsString() {
        return healthStatus;
    }

    /**
     * <p>
     * The application instance was updated.
     * </p>
     * 
     * @return The application instance was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The application instance's name.
     * </p>
     * 
     * @return The application instance's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The application instance's runtime role ARN.
     * </p>
     * 
     * @return The application instance's runtime role ARN.
     */
    public final String runtimeRoleArn() {
        return runtimeRoleArn;
    }

    /**
     * <p>
     * The application instance's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The application instance's status.
     * @see ApplicationInstanceStatus
     */
    public final ApplicationInstanceStatus status() {
        return ApplicationInstanceStatus.fromValue(status);
    }

    /**
     * <p>
     * The application instance's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The application instance's status.
     * @see ApplicationInstanceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The application instance's status description.
     * </p>
     * 
     * @return The application instance's status description.
     */
    public final String statusDescription() {
        return statusDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The application instance's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The application instance's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationInstanceIdToReplace());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRuntimeContextDevice());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRuntimeContextDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationInstanceResponse)) {
            return false;
        }
        DescribeApplicationInstanceResponse other = (DescribeApplicationInstanceResponse) obj;
        return Objects.equals(applicationInstanceId(), other.applicationInstanceId())
                && Objects.equals(applicationInstanceIdToReplace(), other.applicationInstanceIdToReplace())
                && Objects.equals(arn(), other.arn()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(defaultRuntimeContextDevice(), other.defaultRuntimeContextDevice())
                && Objects.equals(defaultRuntimeContextDeviceName(), other.defaultRuntimeContextDeviceName())
                && Objects.equals(description(), other.description())
                && Objects.equals(healthStatusAsString(), other.healthStatusAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(name(), other.name())
                && Objects.equals(runtimeRoleArn(), other.runtimeRoleArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDescription(), other.statusDescription()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationInstanceResponse").add("ApplicationInstanceId", applicationInstanceId())
                .add("ApplicationInstanceIdToReplace", applicationInstanceIdToReplace()).add("Arn", arn())
                .add("CreatedTime", createdTime()).add("DefaultRuntimeContextDevice", defaultRuntimeContextDevice())
                .add("DefaultRuntimeContextDeviceName", defaultRuntimeContextDeviceName()).add("Description", description())
                .add("HealthStatus", healthStatusAsString()).add("LastUpdatedTime", lastUpdatedTime()).add("Name", name())
                .add("RuntimeRoleArn", runtimeRoleArn()).add("Status", statusAsString())
                .add("StatusDescription", statusDescription()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationInstanceId":
            return Optional.ofNullable(clazz.cast(applicationInstanceId()));
        case "ApplicationInstanceIdToReplace":
            return Optional.ofNullable(clazz.cast(applicationInstanceIdToReplace()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DefaultRuntimeContextDevice":
            return Optional.ofNullable(clazz.cast(defaultRuntimeContextDevice()));
        case "DefaultRuntimeContextDeviceName":
            return Optional.ofNullable(clazz.cast(defaultRuntimeContextDeviceName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HealthStatus":
            return Optional.ofNullable(clazz.cast(healthStatusAsString()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuntimeRoleArn":
            return Optional.ofNullable(clazz.cast(runtimeRoleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDescription":
            return Optional.ofNullable(clazz.cast(statusDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationInstanceResponse, T> g) {
        return obj -> g.apply((DescribeApplicationInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationInstanceResponse> {
        /**
         * <p>
         * The application instance's ID.
         * </p>
         * 
         * @param applicationInstanceId
         *        The application instance's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInstanceId(String applicationInstanceId);

        /**
         * <p>
         * The ID of the application instance that this instance replaced.
         * </p>
         * 
         * @param applicationInstanceIdToReplace
         *        The ID of the application instance that this instance replaced.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace);

        /**
         * <p>
         * The application instance's ARN.
         * </p>
         * 
         * @param arn
         *        The application instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When the application instance was created.
         * </p>
         * 
         * @param createdTime
         *        When the application instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The device's ID.
         * </p>
         * 
         * @param defaultRuntimeContextDevice
         *        The device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice);

        /**
         * <p>
         * The device's bane.
         * </p>
         * 
         * @param defaultRuntimeContextDeviceName
         *        The device's bane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRuntimeContextDeviceName(String defaultRuntimeContextDeviceName);

        /**
         * <p>
         * The application instance's description.
         * </p>
         * 
         * @param description
         *        The application instance's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The application instance's health status.
         * </p>
         * 
         * @param healthStatus
         *        The application instance's health status.
         * @see ApplicationInstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationInstanceHealthStatus
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The application instance's health status.
         * </p>
         * 
         * @param healthStatus
         *        The application instance's health status.
         * @see ApplicationInstanceHealthStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationInstanceHealthStatus
         */
        Builder healthStatus(ApplicationInstanceHealthStatus healthStatus);

        /**
         * <p>
         * The application instance was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The application instance was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The application instance's name.
         * </p>
         * 
         * @param name
         *        The application instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The application instance's runtime role ARN.
         * </p>
         * 
         * @param runtimeRoleArn
         *        The application instance's runtime role ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeRoleArn(String runtimeRoleArn);

        /**
         * <p>
         * The application instance's status.
         * </p>
         * 
         * @param status
         *        The application instance's status.
         * @see ApplicationInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationInstanceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The application instance's status.
         * </p>
         * 
         * @param status
         *        The application instance's status.
         * @see ApplicationInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationInstanceStatus
         */
        Builder status(ApplicationInstanceStatus status);

        /**
         * <p>
         * The application instance's status description.
         * </p>
         * 
         * @param statusDescription
         *        The application instance's status description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDescription(String statusDescription);

        /**
         * <p>
         * The application instance's tags.
         * </p>
         * 
         * @param tags
         *        The application instance's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String applicationInstanceId;

        private String applicationInstanceIdToReplace;

        private String arn;

        private Instant createdTime;

        private String defaultRuntimeContextDevice;

        private String defaultRuntimeContextDeviceName;

        private String description;

        private String healthStatus;

        private Instant lastUpdatedTime;

        private String name;

        private String runtimeRoleArn;

        private String status;

        private String statusDescription;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationInstanceResponse model) {
            super(model);
            applicationInstanceId(model.applicationInstanceId);
            applicationInstanceIdToReplace(model.applicationInstanceIdToReplace);
            arn(model.arn);
            createdTime(model.createdTime);
            defaultRuntimeContextDevice(model.defaultRuntimeContextDevice);
            defaultRuntimeContextDeviceName(model.defaultRuntimeContextDeviceName);
            description(model.description);
            healthStatus(model.healthStatus);
            lastUpdatedTime(model.lastUpdatedTime);
            name(model.name);
            runtimeRoleArn(model.runtimeRoleArn);
            status(model.status);
            statusDescription(model.statusDescription);
            tags(model.tags);
        }

        public final String getApplicationInstanceId() {
            return applicationInstanceId;
        }

        public final void setApplicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
        }

        @Override
        public final Builder applicationInstanceId(String applicationInstanceId) {
            this.applicationInstanceId = applicationInstanceId;
            return this;
        }

        public final String getApplicationInstanceIdToReplace() {
            return applicationInstanceIdToReplace;
        }

        public final void setApplicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
        }

        @Override
        public final Builder applicationInstanceIdToReplace(String applicationInstanceIdToReplace) {
            this.applicationInstanceIdToReplace = applicationInstanceIdToReplace;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDefaultRuntimeContextDevice() {
            return defaultRuntimeContextDevice;
        }

        public final void setDefaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
        }

        @Override
        public final Builder defaultRuntimeContextDevice(String defaultRuntimeContextDevice) {
            this.defaultRuntimeContextDevice = defaultRuntimeContextDevice;
            return this;
        }

        public final String getDefaultRuntimeContextDeviceName() {
            return defaultRuntimeContextDeviceName;
        }

        public final void setDefaultRuntimeContextDeviceName(String defaultRuntimeContextDeviceName) {
            this.defaultRuntimeContextDeviceName = defaultRuntimeContextDeviceName;
        }

        @Override
        public final Builder defaultRuntimeContextDeviceName(String defaultRuntimeContextDeviceName) {
            this.defaultRuntimeContextDeviceName = defaultRuntimeContextDeviceName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(ApplicationInstanceHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuntimeRoleArn() {
            return runtimeRoleArn;
        }

        public final void setRuntimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
        }

        @Override
        public final Builder runtimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationInstanceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDescription() {
            return statusDescription;
        }

        public final void setStatusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
        }

        @Override
        public final Builder statusDescription(String statusDescription) {
            this.statusDescription = statusDescription;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DescribeApplicationInstanceResponse build() {
            return new DescribeApplicationInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
