/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A device's network configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EthernetPayload implements SdkPojo, Serializable, ToCopyableBuilder<EthernetPayload.Builder, EthernetPayload> {
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionType").getter(getter(EthernetPayload::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<StaticIpConnectionInfo> STATIC_IP_CONNECTION_INFO_FIELD = SdkField
            .<StaticIpConnectionInfo> builder(MarshallingType.SDK_POJO).memberName("StaticIpConnectionInfo")
            .getter(getter(EthernetPayload::staticIpConnectionInfo)).setter(setter(Builder::staticIpConnectionInfo))
            .constructor(StaticIpConnectionInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticIpConnectionInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_TYPE_FIELD,
            STATIC_IP_CONNECTION_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionType;

    private final StaticIpConnectionInfo staticIpConnectionInfo;

    private EthernetPayload(BuilderImpl builder) {
        this.connectionType = builder.connectionType;
        this.staticIpConnectionInfo = builder.staticIpConnectionInfo;
    }

    /**
     * <p>
     * How the device gets an IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return How the device gets an IP address.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * How the device gets an IP address.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return How the device gets an IP address.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * Network configuration for a static IP connection.
     * </p>
     * 
     * @return Network configuration for a static IP connection.
     */
    public final StaticIpConnectionInfo staticIpConnectionInfo() {
        return staticIpConnectionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(staticIpConnectionInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EthernetPayload)) {
            return false;
        }
        EthernetPayload other = (EthernetPayload) obj;
        return Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(staticIpConnectionInfo(), other.staticIpConnectionInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EthernetPayload").add("ConnectionType", connectionTypeAsString())
                .add("StaticIpConnectionInfo", staticIpConnectionInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "StaticIpConnectionInfo":
            return Optional.ofNullable(clazz.cast(staticIpConnectionInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EthernetPayload, T> g) {
        return obj -> g.apply((EthernetPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EthernetPayload> {
        /**
         * <p>
         * How the device gets an IP address.
         * </p>
         * 
         * @param connectionType
         *        How the device gets an IP address.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * How the device gets an IP address.
         * </p>
         * 
         * @param connectionType
         *        How the device gets an IP address.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * Network configuration for a static IP connection.
         * </p>
         * 
         * @param staticIpConnectionInfo
         *        Network configuration for a static IP connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIpConnectionInfo(StaticIpConnectionInfo staticIpConnectionInfo);

        /**
         * <p>
         * Network configuration for a static IP connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link StaticIpConnectionInfo.Builder} avoiding
         * the need to create one manually via {@link StaticIpConnectionInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link StaticIpConnectionInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #staticIpConnectionInfo(StaticIpConnectionInfo)}.
         * 
         * @param staticIpConnectionInfo
         *        a consumer that will call methods on {@link StaticIpConnectionInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticIpConnectionInfo(StaticIpConnectionInfo)
         */
        default Builder staticIpConnectionInfo(Consumer<StaticIpConnectionInfo.Builder> staticIpConnectionInfo) {
            return staticIpConnectionInfo(StaticIpConnectionInfo.builder().applyMutation(staticIpConnectionInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectionType;

        private StaticIpConnectionInfo staticIpConnectionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(EthernetPayload model) {
            connectionType(model.connectionType);
            staticIpConnectionInfo(model.staticIpConnectionInfo);
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final StaticIpConnectionInfo.Builder getStaticIpConnectionInfo() {
            return staticIpConnectionInfo != null ? staticIpConnectionInfo.toBuilder() : null;
        }

        public final void setStaticIpConnectionInfo(StaticIpConnectionInfo.BuilderImpl staticIpConnectionInfo) {
            this.staticIpConnectionInfo = staticIpConnectionInfo != null ? staticIpConnectionInfo.build() : null;
        }

        @Override
        public final Builder staticIpConnectionInfo(StaticIpConnectionInfo staticIpConnectionInfo) {
            this.staticIpConnectionInfo = staticIpConnectionInfo;
            return this;
        }

        @Override
        public EthernetPayload build() {
            return new EthernetPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
