/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevicesJobsResponse extends PanoramaResponse implements
        ToCopyableBuilder<ListDevicesJobsResponse.Builder, ListDevicesJobsResponse> {
    private static final SdkField<List<DeviceJob>> DEVICE_JOBS_FIELD = SdkField
            .<List<DeviceJob>> builder(MarshallingType.LIST)
            .memberName("DeviceJobs")
            .getter(getter(ListDevicesJobsResponse::deviceJobs))
            .setter(setter(Builder::deviceJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDevicesJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DeviceJob> deviceJobs;

    private final String nextToken;

    private ListDevicesJobsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceJobs = builder.deviceJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDeviceJobs() {
        return deviceJobs != null && !(deviceJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceJobs} method.
     * </p>
     * 
     * @return A list of jobs.
     */
    public final List<DeviceJob> deviceJobs() {
        return deviceJobs;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceJobs() ? deviceJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesJobsResponse)) {
            return false;
        }
        ListDevicesJobsResponse other = (ListDevicesJobsResponse) obj;
        return hasDeviceJobs() == other.hasDeviceJobs() && Objects.equals(deviceJobs(), other.deviceJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDevicesJobsResponse").add("DeviceJobs", hasDeviceJobs() ? deviceJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceJobs":
            return Optional.ofNullable(clazz.cast(deviceJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesJobsResponse, T> g) {
        return obj -> g.apply((ListDevicesJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDevicesJobsResponse> {
        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param deviceJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceJobs(Collection<DeviceJob> deviceJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * 
         * @param deviceJobs
         *        A list of jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceJobs(DeviceJob... deviceJobs);

        /**
         * <p>
         * A list of jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DeviceJob>.Builder} avoiding the
         * need to create one manually via {@link List<DeviceJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceJob>.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceJobs(List<DeviceJob>)}.
         * 
         * @param deviceJobs
         *        a consumer that will call methods on {@link List<DeviceJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceJobs(List<DeviceJob>)
         */
        Builder deviceJobs(Consumer<DeviceJob.Builder>... deviceJobs);

        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private List<DeviceJob> deviceJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesJobsResponse model) {
            super(model);
            deviceJobs(model.deviceJobs);
            nextToken(model.nextToken);
        }

        public final List<DeviceJob.Builder> getDeviceJobs() {
            List<DeviceJob.Builder> result = DeviceJobListCopier.copyToBuilder(this.deviceJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceJobs(Collection<DeviceJob.BuilderImpl> deviceJobs) {
            this.deviceJobs = DeviceJobListCopier.copyFromBuilder(deviceJobs);
        }

        @Override
        public final Builder deviceJobs(Collection<DeviceJob> deviceJobs) {
            this.deviceJobs = DeviceJobListCopier.copy(deviceJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceJobs(DeviceJob... deviceJobs) {
            deviceJobs(Arrays.asList(deviceJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceJobs(Consumer<DeviceJob.Builder>... deviceJobs) {
            deviceJobs(Stream.of(deviceJobs).map(c -> DeviceJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDevicesJobsResponse build() {
            return new ListDevicesJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
