/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationInstanceDependenciesResponse extends PanoramaResponse implements
        ToCopyableBuilder<ListApplicationInstanceDependenciesResponse.Builder, ListApplicationInstanceDependenciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationInstanceDependenciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PackageObject>> PACKAGE_OBJECTS_FIELD = SdkField
            .<List<PackageObject>> builder(MarshallingType.LIST)
            .memberName("PackageObjects")
            .getter(getter(ListApplicationInstanceDependenciesResponse::packageObjects))
            .setter(setter(Builder::packageObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PACKAGE_OBJECTS_FIELD));

    private final String nextToken;

    private final List<PackageObject> packageObjects;

    private ListApplicationInstanceDependenciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packageObjects = builder.packageObjects;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackageObjects property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackageObjects() {
        return packageObjects != null && !(packageObjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of package objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackageObjects} method.
     * </p>
     * 
     * @return A list of package objects.
     */
    public final List<PackageObject> packageObjects() {
        return packageObjects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageObjects() ? packageObjects() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationInstanceDependenciesResponse)) {
            return false;
        }
        ListApplicationInstanceDependenciesResponse other = (ListApplicationInstanceDependenciesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPackageObjects() == other.hasPackageObjects()
                && Objects.equals(packageObjects(), other.packageObjects());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationInstanceDependenciesResponse").add("NextToken", nextToken())
                .add("PackageObjects", hasPackageObjects() ? packageObjects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PackageObjects":
            return Optional.ofNullable(clazz.cast(packageObjects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationInstanceDependenciesResponse, T> g) {
        return obj -> g.apply((ListApplicationInstanceDependenciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationInstanceDependenciesResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of package objects.
         * </p>
         * 
         * @param packageObjects
         *        A list of package objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageObjects(Collection<PackageObject> packageObjects);

        /**
         * <p>
         * A list of package objects.
         * </p>
         * 
         * @param packageObjects
         *        A list of package objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageObjects(PackageObject... packageObjects);

        /**
         * <p>
         * A list of package objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PackageObject>.Builder} avoiding the
         * need to create one manually via {@link List<PackageObject>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageObject>.Builder#build()} is called immediately and
         * its result is passed to {@link #packageObjects(List<PackageObject>)}.
         * 
         * @param packageObjects
         *        a consumer that will call methods on {@link List<PackageObject>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageObjects(List<PackageObject>)
         */
        Builder packageObjects(Consumer<PackageObject.Builder>... packageObjects);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PackageObject> packageObjects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationInstanceDependenciesResponse model) {
            super(model);
            nextToken(model.nextToken);
            packageObjects(model.packageObjects);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PackageObject.Builder> getPackageObjects() {
            List<PackageObject.Builder> result = PackageObjectsCopier.copyToBuilder(this.packageObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageObjects(Collection<PackageObject.BuilderImpl> packageObjects) {
            this.packageObjects = PackageObjectsCopier.copyFromBuilder(packageObjects);
        }

        @Override
        public final Builder packageObjects(Collection<PackageObject> packageObjects) {
            this.packageObjects = PackageObjectsCopier.copy(packageObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageObjects(PackageObject... packageObjects) {
            packageObjects(Arrays.asList(packageObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageObjects(Consumer<PackageObject.Builder>... packageObjects) {
            packageObjects(Stream.of(packageObjects).map(c -> PackageObject.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListApplicationInstanceDependenciesResponse build() {
            return new ListApplicationInstanceDependenciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
