/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackagesResponse extends PanoramaResponse implements
        ToCopyableBuilder<ListPackagesResponse.Builder, ListPackagesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPackagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PackageListItem>> PACKAGES_FIELD = SdkField
            .<List<PackageListItem>> builder(MarshallingType.LIST)
            .memberName("Packages")
            .getter(getter(ListPackagesResponse::packages))
            .setter(setter(Builder::packages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Packages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PACKAGES_FIELD));

    private final String nextToken;

    private final List<PackageListItem> packages;

    private ListPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packages = builder.packages;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Packages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPackages() {
        return packages != null && !(packages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of packages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackages} method.
     * </p>
     * 
     * @return A list of packages.
     */
    public final List<PackageListItem> packages() {
        return packages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPackages() ? packages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagesResponse)) {
            return false;
        }
        ListPackagesResponse other = (ListPackagesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPackages() == other.hasPackages()
                && Objects.equals(packages(), other.packages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPackagesResponse").add("NextToken", nextToken())
                .add("Packages", hasPackages() ? packages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Packages":
            return Optional.ofNullable(clazz.cast(packages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackagesResponse, T> g) {
        return obj -> g.apply((ListPackagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPackagesResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of packages.
         * </p>
         * 
         * @param packages
         *        A list of packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(Collection<PackageListItem> packages);

        /**
         * <p>
         * A list of packages.
         * </p>
         * 
         * @param packages
         *        A list of packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(PackageListItem... packages);

        /**
         * <p>
         * A list of packages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PackageListItem>.Builder} avoiding
         * the need to create one manually via {@link List<PackageListItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageListItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #packages(List<PackageListItem>)}.
         * 
         * @param packages
         *        a consumer that will call methods on {@link List<PackageListItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packages(List<PackageListItem>)
         */
        Builder packages(Consumer<PackageListItem.Builder>... packages);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PackageListItem> packages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackagesResponse model) {
            super(model);
            nextToken(model.nextToken);
            packages(model.packages);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PackageListItem.Builder> getPackages() {
            List<PackageListItem.Builder> result = PackageListCopier.copyToBuilder(this.packages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackages(Collection<PackageListItem.BuilderImpl> packages) {
            this.packages = PackageListCopier.copyFromBuilder(packages);
        }

        @Override
        public final Builder packages(Collection<PackageListItem> packages) {
            this.packages = PackageListCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(PackageListItem... packages) {
            packages(Arrays.asList(packages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(Consumer<PackageListItem.Builder>... packages) {
            packages(Stream.of(packages).map(c -> PackageListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPackagesResponse build() {
            return new ListPackagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
