/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListNodeFromTemplateJobsResponse;

public class ListNodeFromTemplateJobsIterable
implements SdkIterable<ListNodeFromTemplateJobsResponse> {
    private final PanoramaClient client;
    private final ListNodeFromTemplateJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNodeFromTemplateJobsIterable(PanoramaClient client, ListNodeFromTemplateJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNodeFromTemplateJobsResponseFetcher();
    }

    public Iterator<ListNodeFromTemplateJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNodeFromTemplateJobsResponseFetcher
    implements SyncPageFetcher<ListNodeFromTemplateJobsResponse> {
        private ListNodeFromTemplateJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListNodeFromTemplateJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNodeFromTemplateJobsResponse nextPage(ListNodeFromTemplateJobsResponse previousPage) {
            if (previousPage == null) {
                return ListNodeFromTemplateJobsIterable.this.client.listNodeFromTemplateJobs(ListNodeFromTemplateJobsIterable.this.firstRequest);
            }
            return ListNodeFromTemplateJobsIterable.this.client.listNodeFromTemplateJobs((ListNodeFromTemplateJobsRequest)((Object)ListNodeFromTemplateJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

