/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target resource is in use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictException extends PanoramaException implements
        ToCopyableBuilder<ConflictException.Builder, ConflictException> {
    private static final SdkField<List<ConflictExceptionErrorArgument>> ERROR_ARGUMENTS_FIELD = SdkField
            .<List<ConflictExceptionErrorArgument>> builder(MarshallingType.LIST)
            .memberName("ErrorArguments")
            .getter(getter(ConflictException::errorArguments))
            .setter(setter(Builder::errorArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConflictExceptionErrorArgument> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConflictExceptionErrorArgument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorId").getter(getter(ConflictException::errorId)).setter(setter(Builder::errorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ConflictException::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ConflictException::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ARGUMENTS_FIELD,
            ERROR_ID_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ConflictExceptionErrorArgument> errorArguments;

    private final String errorId;

    private final String resourceId;

    private final String resourceType;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.errorArguments = builder.errorArguments;
        this.errorId = builder.errorId;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorArguments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasErrorArguments() {
        return errorArguments != null && !(errorArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attributes that led to the exception and their values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorArguments} method.
     * </p>
     * 
     * @return A list of attributes that led to the exception and their values.
     */
    public List<ConflictExceptionErrorArgument> errorArguments() {
        return errorArguments;
    }

    /**
     * <p>
     * A unique ID for the error.
     * </p>
     * 
     * @return A unique ID for the error.
     */
    public String errorId() {
        return errorId;
    }

    /**
     * <p>
     * The resource's ID.
     * </p>
     * 
     * @return The resource's ID.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The resource's type.
     * </p>
     * 
     * @return The resource's type.
     */
    public String resourceType() {
        return resourceType;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictException>, PanoramaException.Builder {
        /**
         * <p>
         * A list of attributes that led to the exception and their values.
         * </p>
         * 
         * @param errorArguments
         *        A list of attributes that led to the exception and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorArguments(Collection<ConflictExceptionErrorArgument> errorArguments);

        /**
         * <p>
         * A list of attributes that led to the exception and their values.
         * </p>
         * 
         * @param errorArguments
         *        A list of attributes that led to the exception and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorArguments(ConflictExceptionErrorArgument... errorArguments);

        /**
         * <p>
         * A list of attributes that led to the exception and their values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ConflictExceptionErrorArgument>.Builder} avoiding the need to create one manually via {@link List
         * <ConflictExceptionErrorArgument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConflictExceptionErrorArgument>.Builder#build()} is called
         * immediately and its result is passed to {@link #errorArguments(List<ConflictExceptionErrorArgument>)}.
         * 
         * @param errorArguments
         *        a consumer that will call methods on {@link List<ConflictExceptionErrorArgument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorArguments(List<ConflictExceptionErrorArgument>)
         */
        Builder errorArguments(Consumer<ConflictExceptionErrorArgument.Builder>... errorArguments);

        /**
         * <p>
         * A unique ID for the error.
         * </p>
         * 
         * @param errorId
         *        A unique ID for the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorId(String errorId);

        /**
         * <p>
         * The resource's ID.
         * </p>
         * 
         * @param resourceId
         *        The resource's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The resource's type.
         * </p>
         * 
         * @param resourceType
         *        The resource's type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends PanoramaException.BuilderImpl implements Builder {
        private List<ConflictExceptionErrorArgument> errorArguments = DefaultSdkAutoConstructList.getInstance();

        private String errorId;

        private String resourceId;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            errorArguments(model.errorArguments);
            errorId(model.errorId);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
        }

        public final List<ConflictExceptionErrorArgument.Builder> getErrorArguments() {
            List<ConflictExceptionErrorArgument.Builder> result = ConflictExceptionErrorArgumentListCopier
                    .copyToBuilder(this.errorArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorArguments(Collection<ConflictExceptionErrorArgument.BuilderImpl> errorArguments) {
            this.errorArguments = ConflictExceptionErrorArgumentListCopier.copyFromBuilder(errorArguments);
        }

        @Override
        public final Builder errorArguments(Collection<ConflictExceptionErrorArgument> errorArguments) {
            this.errorArguments = ConflictExceptionErrorArgumentListCopier.copy(errorArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorArguments(ConflictExceptionErrorArgument... errorArguments) {
            errorArguments(Arrays.asList(errorArguments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorArguments(Consumer<ConflictExceptionErrorArgument.Builder>... errorArguments) {
            errorArguments(Stream.of(errorArguments).map(c -> ConflictExceptionErrorArgument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getErrorId() {
            return errorId;
        }

        public final void setErrorId(String errorId) {
            this.errorId = errorId;
        }

        @Override
        public final Builder errorId(String errorId) {
            this.errorId = errorId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
