/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceJobResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribeDeviceJobResponse.Builder, DescribeDeviceJobResponse> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeDeviceJobResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceArn").getter(getter(DescribeDeviceJobResponse::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(DescribeDeviceJobResponse::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(DescribeDeviceJobResponse::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceType").getter(getter(DescribeDeviceJobResponse::deviceTypeAsString))
            .setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final SdkField<String> IMAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersion").getter(getter(DescribeDeviceJobResponse::imageVersion))
            .setter(setter(Builder::imageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersion").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(DescribeDeviceJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeDeviceJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD,
            DEVICE_ARN_FIELD, DEVICE_ID_FIELD, DEVICE_NAME_FIELD, DEVICE_TYPE_FIELD, IMAGE_VERSION_FIELD, JOB_ID_FIELD,
            STATUS_FIELD));

    private final Instant createdTime;

    private final String deviceArn;

    private final String deviceId;

    private final String deviceName;

    private final String deviceType;

    private final String imageVersion;

    private final String jobId;

    private final String status;

    private DescribeDeviceJobResponse(BuilderImpl builder) {
        super(builder);
        this.createdTime = builder.createdTime;
        this.deviceArn = builder.deviceArn;
        this.deviceId = builder.deviceId;
        this.deviceName = builder.deviceName;
        this.deviceType = builder.deviceType;
        this.imageVersion = builder.imageVersion;
        this.jobId = builder.jobId;
        this.status = builder.status;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The device's ARN.
     * </p>
     * 
     * @return The device's ARN.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The device's ID.
     * </p>
     * 
     * @return The device's ID.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The device's name.
     * </p>
     * 
     * @return The device's name.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final DeviceType deviceType() {
        return DeviceType.fromValue(deviceType);
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceType} will
     * return {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deviceTypeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final String deviceTypeAsString() {
        return deviceType;
    }

    /**
     * <p>
     * For an OTA job, the target version of the device software.
     * </p>
     * 
     * @return For an OTA job, the target version of the device software.
     */
    public final String imageVersion() {
        return imageVersion;
    }

    /**
     * <p>
     * The job's ID.
     * </p>
     * 
     * @return The job's ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateProgress#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see UpdateProgress
     */
    public final UpdateProgress status() {
        return UpdateProgress.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateProgress#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see UpdateProgress
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceJobResponse)) {
            return false;
        }
        DescribeDeviceJobResponse other = (DescribeDeviceJobResponse) obj;
        return Objects.equals(createdTime(), other.createdTime()) && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(deviceId(), other.deviceId()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(deviceTypeAsString(), other.deviceTypeAsString())
                && Objects.equals(imageVersion(), other.imageVersion()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceJobResponse").add("CreatedTime", createdTime()).add("DeviceArn", deviceArn())
                .add("DeviceId", deviceId()).add("DeviceName", deviceName()).add("DeviceType", deviceTypeAsString())
                .add("ImageVersion", imageVersion()).add("JobId", jobId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceTypeAsString()));
        case "ImageVersion":
            return Optional.ofNullable(clazz.cast(imageVersion()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceJobResponse, T> g) {
        return obj -> g.apply((DescribeDeviceJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeviceJobResponse> {
        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param createdTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The device's ARN.
         * </p>
         * 
         * @param deviceArn
         *        The device's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The device's ID.
         * </p>
         * 
         * @param deviceId
         *        The device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The device's name.
         * </p>
         * 
         * @param deviceName
         *        The device's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param deviceType
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param deviceType
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder deviceType(DeviceType deviceType);

        /**
         * <p>
         * For an OTA job, the target version of the device software.
         * </p>
         * 
         * @param imageVersion
         *        For an OTA job, the target version of the device software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersion(String imageVersion);

        /**
         * <p>
         * The job's ID.
         * </p>
         * 
         * @param jobId
         *        The job's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see UpdateProgress
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateProgress
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see UpdateProgress
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateProgress
         */
        Builder status(UpdateProgress status);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private Instant createdTime;

        private String deviceArn;

        private String deviceId;

        private String deviceName;

        private String deviceType;

        private String imageVersion;

        private String jobId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceJobResponse model) {
            super(model);
            createdTime(model.createdTime);
            deviceArn(model.deviceArn);
            deviceId(model.deviceId);
            deviceName(model.deviceName);
            deviceType(model.deviceType);
            imageVersion(model.imageVersion);
            jobId(model.jobId);
            status(model.status);
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        public final Builder deviceType(DeviceType deviceType) {
            this.deviceType(deviceType == null ? null : deviceType.toString());
            return this;
        }

        public final String getImageVersion() {
            return imageVersion;
        }

        public final void setImageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
        }

        @Override
        public final Builder imageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateProgress status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeDeviceJobResponse build() {
            return new DescribeDeviceJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
