/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackageImportJobsResponse extends PanoramaResponse implements
        ToCopyableBuilder<ListPackageImportJobsResponse.Builder, ListPackageImportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPackageImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<PackageImportJob>> PACKAGE_IMPORT_JOBS_FIELD = SdkField
            .<List<PackageImportJob>> builder(MarshallingType.LIST)
            .memberName("PackageImportJobs")
            .getter(getter(ListPackageImportJobsResponse::packageImportJobs))
            .setter(setter(Builder::packageImportJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageImportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageImportJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageImportJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PACKAGE_IMPORT_JOBS_FIELD));

    private final String nextToken;

    private final List<PackageImportJob> packageImportJobs;

    private ListPackageImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packageImportJobs = builder.packageImportJobs;
    }

    /**
     * <p>
     * A pagination token that's included if more results are available.
     * </p>
     * 
     * @return A pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackageImportJobs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackageImportJobs() {
        return packageImportJobs != null && !(packageImportJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of package import jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackageImportJobs} method.
     * </p>
     * 
     * @return A list of package import jobs.
     */
    public final List<PackageImportJob> packageImportJobs() {
        return packageImportJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageImportJobs() ? packageImportJobs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageImportJobsResponse)) {
            return false;
        }
        ListPackageImportJobsResponse other = (ListPackageImportJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPackageImportJobs() == other.hasPackageImportJobs()
                && Objects.equals(packageImportJobs(), other.packageImportJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPackageImportJobsResponse").add("NextToken", nextToken())
                .add("PackageImportJobs", hasPackageImportJobs() ? packageImportJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PackageImportJobs":
            return Optional.ofNullable(clazz.cast(packageImportJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageImportJobsResponse, T> g) {
        return obj -> g.apply((ListPackageImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPackageImportJobsResponse> {
        /**
         * <p>
         * A pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of package import jobs.
         * </p>
         * 
         * @param packageImportJobs
         *        A list of package import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageImportJobs(Collection<PackageImportJob> packageImportJobs);

        /**
         * <p>
         * A list of package import jobs.
         * </p>
         * 
         * @param packageImportJobs
         *        A list of package import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageImportJobs(PackageImportJob... packageImportJobs);

        /**
         * <p>
         * A list of package import jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PackageImportJob>.Builder} avoiding
         * the need to create one manually via {@link List<PackageImportJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageImportJob>.Builder#build()} is called immediately and
         * its result is passed to {@link #packageImportJobs(List<PackageImportJob>)}.
         * 
         * @param packageImportJobs
         *        a consumer that will call methods on {@link List<PackageImportJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageImportJobs(List<PackageImportJob>)
         */
        Builder packageImportJobs(Consumer<PackageImportJob.Builder>... packageImportJobs);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PackageImportJob> packageImportJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageImportJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            packageImportJobs(model.packageImportJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PackageImportJob.Builder> getPackageImportJobs() {
            List<PackageImportJob.Builder> result = PackageImportJobListCopier.copyToBuilder(this.packageImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageImportJobs(Collection<PackageImportJob.BuilderImpl> packageImportJobs) {
            this.packageImportJobs = PackageImportJobListCopier.copyFromBuilder(packageImportJobs);
        }

        @Override
        public final Builder packageImportJobs(Collection<PackageImportJob> packageImportJobs) {
            this.packageImportJobs = PackageImportJobListCopier.copy(packageImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageImportJobs(PackageImportJob... packageImportJobs) {
            packageImportJobs(Arrays.asList(packageImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageImportJobs(Consumer<PackageImportJob.Builder>... packageImportJobs) {
            packageImportJobs(Stream.of(packageImportJobs).map(c -> PackageImportJob.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPackageImportJobsResponse build() {
            return new ListPackageImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
