/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A node interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeInterface implements SdkPojo, Serializable, ToCopyableBuilder<NodeInterface.Builder, NodeInterface> {
    private static final SdkField<List<NodeInputPort>> INPUTS_FIELD = SdkField
            .<List<NodeInputPort>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(NodeInterface::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeInputPort> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeInputPort::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<NodeOutputPort>> OUTPUTS_FIELD = SdkField
            .<List<NodeOutputPort>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(NodeInterface::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NodeOutputPort> builder(MarshallingType.SDK_POJO)
                                            .constructor(NodeOutputPort::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUTS_FIELD, OUTPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<NodeInputPort> inputs;

    private final List<NodeOutputPort> outputs;

    private NodeInterface(BuilderImpl builder) {
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The node interface's inputs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The node interface's inputs.
     */
    public final List<NodeInputPort> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The node interface's outputs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The node interface's outputs.
     */
    public final List<NodeOutputPort> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInterface)) {
            return false;
        }
        NodeInterface other = (NodeInterface) obj;
        return hasInputs() == other.hasInputs() && Objects.equals(inputs(), other.inputs()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeInterface").add("Inputs", hasInputs() ? inputs() : null)
                .add("Outputs", hasOutputs() ? outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeInterface, T> g) {
        return obj -> g.apply((NodeInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeInterface> {
        /**
         * <p>
         * The node interface's inputs.
         * </p>
         * 
         * @param inputs
         *        The node interface's inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<NodeInputPort> inputs);

        /**
         * <p>
         * The node interface's inputs.
         * </p>
         * 
         * @param inputs
         *        The node interface's inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(NodeInputPort... inputs);

        /**
         * <p>
         * The node interface's inputs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NodeInputPort>.Builder} avoiding the
         * need to create one manually via {@link List<NodeInputPort>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeInputPort>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputs(List<NodeInputPort>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on {@link List<NodeInputPort>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(List<NodeInputPort>)
         */
        Builder inputs(Consumer<NodeInputPort.Builder>... inputs);

        /**
         * <p>
         * The node interface's outputs.
         * </p>
         * 
         * @param outputs
         *        The node interface's outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<NodeOutputPort> outputs);

        /**
         * <p>
         * The node interface's outputs.
         * </p>
         * 
         * @param outputs
         *        The node interface's outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(NodeOutputPort... outputs);

        /**
         * <p>
         * The node interface's outputs.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NodeOutputPort>.Builder} avoiding
         * the need to create one manually via {@link List<NodeOutputPort>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NodeOutputPort>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputs(List<NodeOutputPort>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<NodeOutputPort>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<NodeOutputPort>)
         */
        Builder outputs(Consumer<NodeOutputPort.Builder>... outputs);
    }

    static final class BuilderImpl implements Builder {
        private List<NodeInputPort> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<NodeOutputPort> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInterface model) {
            inputs(model.inputs);
            outputs(model.outputs);
        }

        public final List<NodeInputPort.Builder> getInputs() {
            List<NodeInputPort.Builder> result = InputPortListCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<NodeInputPort.BuilderImpl> inputs) {
            this.inputs = InputPortListCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<NodeInputPort> inputs) {
            this.inputs = InputPortListCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(NodeInputPort... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<NodeInputPort.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> NodeInputPort.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NodeOutputPort.Builder> getOutputs() {
            List<NodeOutputPort.Builder> result = OutputPortListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<NodeOutputPort.BuilderImpl> outputs) {
            this.outputs = OutputPortListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<NodeOutputPort> outputs) {
            this.outputs = OutputPortListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(NodeOutputPort... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<NodeOutputPort.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> NodeOutputPort.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public NodeInterface build() {
            return new NodeInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
