/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An output configuration for a package import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageImportJobOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageImportJobOutputConfig.Builder, PackageImportJobOutputConfig> {
    private static final SdkField<PackageVersionOutputConfig> PACKAGE_VERSION_OUTPUT_CONFIG_FIELD = SdkField
            .<PackageVersionOutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("PackageVersionOutputConfig")
            .getter(getter(PackageImportJobOutputConfig::packageVersionOutputConfig))
            .setter(setter(Builder::packageVersionOutputConfig))
            .constructor(PackageVersionOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersionOutputConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PACKAGE_VERSION_OUTPUT_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final PackageVersionOutputConfig packageVersionOutputConfig;

    private PackageImportJobOutputConfig(BuilderImpl builder) {
        this.packageVersionOutputConfig = builder.packageVersionOutputConfig;
    }

    /**
     * <p>
     * The package version's output configuration.
     * </p>
     * 
     * @return The package version's output configuration.
     */
    public final PackageVersionOutputConfig packageVersionOutputConfig() {
        return packageVersionOutputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageVersionOutputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageImportJobOutputConfig)) {
            return false;
        }
        PackageImportJobOutputConfig other = (PackageImportJobOutputConfig) obj;
        return Objects.equals(packageVersionOutputConfig(), other.packageVersionOutputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageImportJobOutputConfig").add("PackageVersionOutputConfig", packageVersionOutputConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageVersionOutputConfig":
            return Optional.ofNullable(clazz.cast(packageVersionOutputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageImportJobOutputConfig, T> g) {
        return obj -> g.apply((PackageImportJobOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageImportJobOutputConfig> {
        /**
         * <p>
         * The package version's output configuration.
         * </p>
         * 
         * @param packageVersionOutputConfig
         *        The package version's output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersionOutputConfig(PackageVersionOutputConfig packageVersionOutputConfig);

        /**
         * <p>
         * The package version's output configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageVersionOutputConfig.Builder}
         * avoiding the need to create one manually via {@link PackageVersionOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageVersionOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #packageVersionOutputConfig(PackageVersionOutputConfig)}.
         * 
         * @param packageVersionOutputConfig
         *        a consumer that will call methods on {@link PackageVersionOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVersionOutputConfig(PackageVersionOutputConfig)
         */
        default Builder packageVersionOutputConfig(Consumer<PackageVersionOutputConfig.Builder> packageVersionOutputConfig) {
            return packageVersionOutputConfig(PackageVersionOutputConfig.builder().applyMutation(packageVersionOutputConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PackageVersionOutputConfig packageVersionOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageImportJobOutputConfig model) {
            packageVersionOutputConfig(model.packageVersionOutputConfig);
        }

        public final PackageVersionOutputConfig.Builder getPackageVersionOutputConfig() {
            return packageVersionOutputConfig != null ? packageVersionOutputConfig.toBuilder() : null;
        }

        public final void setPackageVersionOutputConfig(PackageVersionOutputConfig.BuilderImpl packageVersionOutputConfig) {
            this.packageVersionOutputConfig = packageVersionOutputConfig != null ? packageVersionOutputConfig.build() : null;
        }

        @Override
        public final Builder packageVersionOutputConfig(PackageVersionOutputConfig packageVersionOutputConfig) {
            this.packageVersionOutputConfig = packageVersionOutputConfig;
            return this;
        }

        @Override
        public PackageImportJobOutputConfig build() {
            return new PackageImportJobOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
