/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request contains an invalid parameter value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends PanoramaException implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final SdkField<List<ValidationExceptionErrorArgument>> ERROR_ARGUMENTS_FIELD = SdkField
            .<List<ValidationExceptionErrorArgument>> builder(MarshallingType.LIST)
            .memberName("ErrorArguments")
            .getter(getter(ValidationException::errorArguments))
            .setter(setter(Builder::errorArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationExceptionErrorArgument> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationExceptionErrorArgument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorId").getter(getter(ValidationException::errorId)).setter(setter(Builder::errorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorId").build()).build();

    private static final SdkField<List<ValidationExceptionField>> FIELDS_FIELD = SdkField
            .<List<ValidationExceptionField>> builder(MarshallingType.LIST)
            .memberName("Fields")
            .getter(getter(ValidationException::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationExceptionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationExceptionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ValidationException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ARGUMENTS_FIELD,
            ERROR_ID_FIELD, FIELDS_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValidationExceptionErrorArgument> errorArguments;

    private final String errorId;

    private final List<ValidationExceptionField> fields;

    private final String reason;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.errorArguments = builder.errorArguments;
        this.errorId = builder.errorId;
        this.fields = builder.fields;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorArguments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasErrorArguments() {
        return errorArguments != null && !(errorArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attributes that led to the exception and their values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorArguments} method.
     * </p>
     * 
     * @return A list of attributes that led to the exception and their values.
     */
    public List<ValidationExceptionErrorArgument> errorArguments() {
        return errorArguments;
    }

    /**
     * <p>
     * A unique ID for the error.
     * </p>
     * 
     * @return A unique ID for the error.
     */
    public String errorId() {
        return errorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of request parameters that failed validation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A list of request parameters that failed validation.
     */
    public List<ValidationExceptionField> fields() {
        return fields;
    }

    /**
     * <p>
     * The reason that validation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason that validation failed.
     * @see ValidationExceptionReason
     */
    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason that validation failed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason that validation failed.
     * @see ValidationExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>, PanoramaException.Builder {
        /**
         * <p>
         * A list of attributes that led to the exception and their values.
         * </p>
         * 
         * @param errorArguments
         *        A list of attributes that led to the exception and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorArguments(Collection<ValidationExceptionErrorArgument> errorArguments);

        /**
         * <p>
         * A list of attributes that led to the exception and their values.
         * </p>
         * 
         * @param errorArguments
         *        A list of attributes that led to the exception and their values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorArguments(ValidationExceptionErrorArgument... errorArguments);

        /**
         * <p>
         * A list of attributes that led to the exception and their values.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ValidationExceptionErrorArgument>.Builder} avoiding the need to create one manually via {@link List
         * <ValidationExceptionErrorArgument>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationExceptionErrorArgument>.Builder#build()} is called
         * immediately and its result is passed to {@link #errorArguments(List<ValidationExceptionErrorArgument>)}.
         * 
         * @param errorArguments
         *        a consumer that will call methods on {@link List<ValidationExceptionErrorArgument>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorArguments(List<ValidationExceptionErrorArgument>)
         */
        Builder errorArguments(Consumer<ValidationExceptionErrorArgument.Builder>... errorArguments);

        /**
         * <p>
         * A unique ID for the error.
         * </p>
         * 
         * @param errorId
         *        A unique ID for the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorId(String errorId);

        /**
         * <p>
         * A list of request parameters that failed validation.
         * </p>
         * 
         * @param fields
         *        A list of request parameters that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<ValidationExceptionField> fields);

        /**
         * <p>
         * A list of request parameters that failed validation.
         * </p>
         * 
         * @param fields
         *        A list of request parameters that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(ValidationExceptionField... fields);

        /**
         * <p>
         * A list of request parameters that failed validation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ValidationExceptionField>.Builder}
         * avoiding the need to create one manually via {@link List<ValidationExceptionField>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationExceptionField>.Builder#build()} is called
         * immediately and its result is passed to {@link #fields(List<ValidationExceptionField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on {@link List<ValidationExceptionField>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(List<ValidationExceptionField>)
         */
        Builder fields(Consumer<ValidationExceptionField.Builder>... fields);

        /**
         * <p>
         * The reason that validation failed.
         * </p>
         * 
         * @param reason
         *        The reason that validation failed.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason that validation failed.
         * </p>
         * 
         * @param reason
         *        The reason that validation failed.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(ValidationExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends PanoramaException.BuilderImpl implements Builder {
        private List<ValidationExceptionErrorArgument> errorArguments = DefaultSdkAutoConstructList.getInstance();

        private String errorId;

        private List<ValidationExceptionField> fields = DefaultSdkAutoConstructList.getInstance();

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            errorArguments(model.errorArguments);
            errorId(model.errorId);
            fields(model.fields);
            reason(model.reason);
        }

        public final List<ValidationExceptionErrorArgument.Builder> getErrorArguments() {
            List<ValidationExceptionErrorArgument.Builder> result = ValidationExceptionErrorArgumentListCopier
                    .copyToBuilder(this.errorArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorArguments(Collection<ValidationExceptionErrorArgument.BuilderImpl> errorArguments) {
            this.errorArguments = ValidationExceptionErrorArgumentListCopier.copyFromBuilder(errorArguments);
        }

        @Override
        public final Builder errorArguments(Collection<ValidationExceptionErrorArgument> errorArguments) {
            this.errorArguments = ValidationExceptionErrorArgumentListCopier.copy(errorArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorArguments(ValidationExceptionErrorArgument... errorArguments) {
            errorArguments(Arrays.asList(errorArguments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorArguments(Consumer<ValidationExceptionErrorArgument.Builder>... errorArguments) {
            errorArguments(Stream.of(errorArguments)
                    .map(c -> ValidationExceptionErrorArgument.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getErrorId() {
            return errorId;
        }

        public final void setErrorId(String errorId) {
            this.errorId = errorId;
        }

        @Override
        public final Builder errorId(String errorId) {
            this.errorId = errorId;
            return this;
        }

        public final List<ValidationExceptionField.Builder> getFields() {
            List<ValidationExceptionField.Builder> result = ValidationExceptionFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<ValidationExceptionField.BuilderImpl> fields) {
            this.fields = ValidationExceptionFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<ValidationExceptionField> fields) {
            this.fields = ValidationExceptionFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(ValidationExceptionField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<ValidationExceptionField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> ValidationExceptionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
