/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the latest device job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LatestDeviceJob implements SdkPojo, Serializable, ToCopyableBuilder<LatestDeviceJob.Builder, LatestDeviceJob> {
    private static final SdkField<String> IMAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageVersion").getter(getter(LatestDeviceJob::imageVersion)).setter(setter(Builder::imageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LatestDeviceJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_VERSION_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageVersion;

    private final String status;

    private LatestDeviceJob(BuilderImpl builder) {
        this.imageVersion = builder.imageVersion;
        this.status = builder.status;
    }

    /**
     * <p>
     * The target version of the device software.
     * </p>
     * 
     * @return The target version of the device software.
     */
    public final String imageVersion() {
        return imageVersion;
    }

    /**
     * <p>
     * Status of the latest device job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateProgress#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the latest device job.
     * @see UpdateProgress
     */
    public final UpdateProgress status() {
        return UpdateProgress.fromValue(status);
    }

    /**
     * <p>
     * Status of the latest device job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateProgress#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the latest device job.
     * @see UpdateProgress
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestDeviceJob)) {
            return false;
        }
        LatestDeviceJob other = (LatestDeviceJob) obj;
        return Objects.equals(imageVersion(), other.imageVersion()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LatestDeviceJob").add("ImageVersion", imageVersion()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageVersion":
            return Optional.ofNullable(clazz.cast(imageVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LatestDeviceJob, T> g) {
        return obj -> g.apply((LatestDeviceJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LatestDeviceJob> {
        /**
         * <p>
         * The target version of the device software.
         * </p>
         * 
         * @param imageVersion
         *        The target version of the device software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageVersion(String imageVersion);

        /**
         * <p>
         * Status of the latest device job.
         * </p>
         * 
         * @param status
         *        Status of the latest device job.
         * @see UpdateProgress
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateProgress
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the latest device job.
         * </p>
         * 
         * @param status
         *        Status of the latest device job.
         * @see UpdateProgress
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateProgress
         */
        Builder status(UpdateProgress status);
    }

    static final class BuilderImpl implements Builder {
        private String imageVersion;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LatestDeviceJob model) {
            imageVersion(model.imageVersion);
            status(model.status);
        }

        public final String getImageVersion() {
            return imageVersion;
        }

        public final void setImageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
        }

        @Override
        public final Builder imageVersion(String imageVersion) {
            this.imageVersion = imageVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateProgress status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public LatestDeviceJob build() {
            return new LatestDeviceJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
