/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePackageImportJobResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribePackageImportJobResponse.Builder, DescribePackageImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(DescribePackageImportJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(DescribePackageImportJobResponse::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(DescribePackageImportJobResponse::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<PackageImportJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<PackageImportJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(DescribePackageImportJobResponse::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(PackageImportJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<PackageImportJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<PackageImportJobOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(DescribePackageImportJobResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(PackageImportJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<PackageImportJobOutput> OUTPUT_FIELD = SdkField
            .<PackageImportJobOutput> builder(MarshallingType.SDK_POJO).memberName("Output")
            .getter(getter(DescribePackageImportJobResponse::output)).setter(setter(Builder::output))
            .constructor(PackageImportJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribePackageImportJobResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribePackageImportJobResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribePackageImportJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(DescribePackageImportJobResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField
            .<List<JobResourceTags>> builder(MarshallingType.LIST)
            .memberName("JobTags")
            .getter(getter(DescribePackageImportJobResponse::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobResourceTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobResourceTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            CLIENT_TOKEN_FIELD, JOB_TYPE_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, OUTPUT_FIELD, CREATED_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, JOB_TAGS_FIELD));

    private final String jobId;

    private final String clientToken;

    private final String jobType;

    private final PackageImportJobInputConfig inputConfig;

    private final PackageImportJobOutputConfig outputConfig;

    private final PackageImportJobOutput output;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private final String status;

    private final String statusMessage;

    private final List<JobResourceTags> jobTags;

    private DescribePackageImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.clientToken = builder.clientToken;
        this.jobType = builder.jobType;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.output = builder.output;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.jobTags = builder.jobTags;
    }

    /**
     * <p>
     * The job's ID.
     * </p>
     * 
     * @return The job's ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The job's client token.
     * </p>
     * 
     * @return The job's client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link PackageImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job's type.
     * @see PackageImportJobType
     */
    public final PackageImportJobType jobType() {
        return PackageImportJobType.fromValue(jobType);
    }

    /**
     * <p>
     * The job's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link PackageImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The job's type.
     * @see PackageImportJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The job's input config.
     * </p>
     * 
     * @return The job's input config.
     */
    public final PackageImportJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * The job's output config.
     * </p>
     * 
     * @return The job's output config.
     */
    public final PackageImportJobOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The job's output.
     * </p>
     * 
     * @return The job's output.
     */
    public final PackageImportJobOutput output() {
        return output;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * When the job was updated.
     * </p>
     * 
     * @return When the job was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see PackageImportJobStatus
     */
    public final PackageImportJobStatus status() {
        return PackageImportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageImportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see PackageImportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The job's status message.
     * </p>
     * 
     * @return The job's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The job's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return The job's tags.
     */
    public final List<JobResourceTags> jobTags() {
        return jobTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageImportJobResponse)) {
            return false;
        }
        DescribePackageImportJobResponse other = (DescribePackageImportJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(output(), other.output()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && hasJobTags() == other.hasJobTags()
                && Objects.equals(jobTags(), other.jobTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePackageImportJobResponse").add("JobId", jobId()).add("ClientToken", clientToken())
                .add("JobType", jobTypeAsString()).add("InputConfig", inputConfig()).add("OutputConfig", outputConfig())
                .add("Output", output()).add("CreatedTime", createdTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("JobTags", hasJobTags() ? jobTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "JobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageImportJobResponse, T> g) {
        return obj -> g.apply((DescribePackageImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribePackageImportJobResponse> {
        /**
         * <p>
         * The job's ID.
         * </p>
         * 
         * @param jobId
         *        The job's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The job's client token.
         * </p>
         * 
         * @param clientToken
         *        The job's client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The job's type.
         * </p>
         * 
         * @param jobType
         *        The job's type.
         * @see PackageImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageImportJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The job's type.
         * </p>
         * 
         * @param jobType
         *        The job's type.
         * @see PackageImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageImportJobType
         */
        Builder jobType(PackageImportJobType jobType);

        /**
         * <p>
         * The job's input config.
         * </p>
         * 
         * @param inputConfig
         *        The job's input config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(PackageImportJobInputConfig inputConfig);

        /**
         * <p>
         * The job's input config.
         * </p>
         * This is a convenience that creates an instance of the {@link PackageImportJobInputConfig.Builder} avoiding
         * the need to create one manually via {@link PackageImportJobInputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageImportJobInputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputConfig(PackageImportJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link PackageImportJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(PackageImportJobInputConfig)
         */
        default Builder inputConfig(Consumer<PackageImportJobInputConfig.Builder> inputConfig) {
            return inputConfig(PackageImportJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * The job's output config.
         * </p>
         * 
         * @param outputConfig
         *        The job's output config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(PackageImportJobOutputConfig outputConfig);

        /**
         * <p>
         * The job's output config.
         * </p>
         * This is a convenience that creates an instance of the {@link PackageImportJobOutputConfig.Builder} avoiding
         * the need to create one manually via {@link PackageImportJobOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageImportJobOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(PackageImportJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link PackageImportJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(PackageImportJobOutputConfig)
         */
        default Builder outputConfig(Consumer<PackageImportJobOutputConfig.Builder> outputConfig) {
            return outputConfig(PackageImportJobOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The job's output.
         * </p>
         * 
         * @param output
         *        The job's output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(PackageImportJobOutput output);

        /**
         * <p>
         * The job's output.
         * </p>
         * This is a convenience that creates an instance of the {@link PackageImportJobOutput.Builder} avoiding the
         * need to create one manually via {@link PackageImportJobOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageImportJobOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #output(PackageImportJobOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link PackageImportJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(PackageImportJobOutput)
         */
        default Builder output(Consumer<PackageImportJobOutput.Builder> output) {
            return output(PackageImportJobOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param createdTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * When the job was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        When the job was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see PackageImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageImportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param status
         *        The job's status.
         * @see PackageImportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageImportJobStatus
         */
        Builder status(PackageImportJobStatus status);

        /**
         * <p>
         * The job's status message.
         * </p>
         * 
         * @param statusMessage
         *        The job's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The job's tags.
         * </p>
         * 
         * @param jobTags
         *        The job's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Collection<JobResourceTags> jobTags);

        /**
         * <p>
         * The job's tags.
         * </p>
         * 
         * @param jobTags
         *        The job's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(JobResourceTags... jobTags);

        /**
         * <p>
         * The job's tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobResourceTags>.Builder} avoiding the need
         * to create one manually via {@link List<JobResourceTags>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobResourceTags>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobTags(List<JobResourceTags>)}.
         * 
         * @param jobTags
         *        a consumer that will call methods on {@link List<JobResourceTags>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTags(List<JobResourceTags>)
         */
        Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String jobId;

        private String clientToken;

        private String jobType;

        private PackageImportJobInputConfig inputConfig;

        private PackageImportJobOutputConfig outputConfig;

        private PackageImportJobOutput output;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private String status;

        private String statusMessage;

        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageImportJobResponse model) {
            super(model);
            jobId(model.jobId);
            clientToken(model.clientToken);
            jobType(model.jobType);
            inputConfig(model.inputConfig);
            outputConfig(model.outputConfig);
            output(model.output);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
            status(model.status);
            statusMessage(model.statusMessage);
            jobTags(model.jobTags);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        @Transient
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        @Transient
        public final Builder jobType(PackageImportJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final PackageImportJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(PackageImportJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputConfig(PackageImportJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final PackageImportJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(PackageImportJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(PackageImportJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final PackageImportJobOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(PackageImportJobOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        @Transient
        public final Builder output(PackageImportJobOutput output) {
            this.output = output;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(PackageImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        @Transient
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(JobResourceTags... jobTags) {
            jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags) {
            jobTags(Stream.of(jobTags).map(c -> JobResourceTags.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePackageImportJobResponse build() {
            return new DescribePackageImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
