/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A package object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageObject implements SdkPojo, Serializable, ToCopyableBuilder<PackageObject.Builder, PackageObject> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PackageObject::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(PackageObject::packageVersion)).setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersion").build()).build();

    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchVersion").getter(getter(PackageObject::patchVersion)).setter(setter(Builder::patchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PACKAGE_VERSION_FIELD, PATCH_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String packageVersion;

    private final String patchVersion;

    private PackageObject(BuilderImpl builder) {
        this.name = builder.name;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
    }

    /**
     * <p>
     * The object's name.
     * </p>
     * 
     * @return The object's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The object's package version.
     * </p>
     * 
     * @return The object's package version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * The object's patch version.
     * </p>
     * 
     * @return The object's patch version.
     */
    public final String patchVersion() {
        return patchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(patchVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageObject)) {
            return false;
        }
        PackageObject other = (PackageObject) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(patchVersion(), other.patchVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageObject").add("Name", name()).add("PackageVersion", packageVersion())
                .add("PatchVersion", patchVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "PatchVersion":
            return Optional.ofNullable(clazz.cast(patchVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageObject, T> g) {
        return obj -> g.apply((PackageObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageObject> {
        /**
         * <p>
         * The object's name.
         * </p>
         * 
         * @param name
         *        The object's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The object's package version.
         * </p>
         * 
         * @param packageVersion
         *        The object's package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * The object's patch version.
         * </p>
         * 
         * @param patchVersion
         *        The object's patch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchVersion(String patchVersion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String packageVersion;

        private String patchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageObject model) {
            name(model.name);
            packageVersion(model.packageVersion);
            patchVersion(model.patchVersion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        @Transient
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        @Transient
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        @Override
        public PackageObject build() {
            return new PackageObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
