/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNodeFromTemplateJobRequest extends PanoramaRequest implements
        ToCopyableBuilder<CreateNodeFromTemplateJobRequest.Builder, CreateNodeFromTemplateJobRequest> {
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateType").getter(getter(CreateNodeFromTemplateJobRequest::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()).build();

    private static final SdkField<String> OUTPUT_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputPackageName").getter(getter(CreateNodeFromTemplateJobRequest::outputPackageName))
            .setter(setter(Builder::outputPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageName").build()).build();

    private static final SdkField<String> OUTPUT_PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputPackageVersion").getter(getter(CreateNodeFromTemplateJobRequest::outputPackageVersion))
            .setter(setter(Builder::outputPackageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputPackageVersion").build())
            .build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeName").getter(getter(CreateNodeFromTemplateJobRequest::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeName").build()).build();

    private static final SdkField<String> NODE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeDescription").getter(getter(CreateNodeFromTemplateJobRequest::nodeDescription))
            .setter(setter(Builder::nodeDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDescription").build()).build();

    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TemplateParameters")
            .getter(getter(CreateNodeFromTemplateJobRequest::templateParameters))
            .setter(setter(Builder::templateParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField
            .<List<JobResourceTags>> builder(MarshallingType.LIST)
            .memberName("JobTags")
            .getter(getter(CreateNodeFromTemplateJobRequest::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobResourceTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobResourceTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_TYPE_FIELD,
            OUTPUT_PACKAGE_NAME_FIELD, OUTPUT_PACKAGE_VERSION_FIELD, NODE_NAME_FIELD, NODE_DESCRIPTION_FIELD,
            TEMPLATE_PARAMETERS_FIELD, JOB_TAGS_FIELD));

    private final String templateType;

    private final String outputPackageName;

    private final String outputPackageVersion;

    private final String nodeName;

    private final String nodeDescription;

    private final Map<String, String> templateParameters;

    private final List<JobResourceTags> jobTags;

    private CreateNodeFromTemplateJobRequest(BuilderImpl builder) {
        super(builder);
        this.templateType = builder.templateType;
        this.outputPackageName = builder.outputPackageName;
        this.outputPackageVersion = builder.outputPackageVersion;
        this.nodeName = builder.nodeName;
        this.nodeDescription = builder.nodeDescription;
        this.templateParameters = builder.templateParameters;
        this.jobTags = builder.jobTags;
    }

    /**
     * <p>
     * The type of node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of node.
     * @see TemplateType
     */
    public final TemplateType templateType() {
        return TemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The type of node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link TemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The type of node.
     * @see TemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * An output package name for the node.
     * </p>
     * 
     * @return An output package name for the node.
     */
    public final String outputPackageName() {
        return outputPackageName;
    }

    /**
     * <p>
     * An output package version for the node.
     * </p>
     * 
     * @return An output package version for the node.
     */
    public final String outputPackageVersion() {
        return outputPackageVersion;
    }

    /**
     * <p>
     * A name for the node.
     * </p>
     * 
     * @return A name for the node.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * A description for the node.
     * </p>
     * 
     * @return A description for the node.
     */
    public final String nodeDescription() {
        return nodeDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplateParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplateParameters() {
        return templateParameters != null && !(templateParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Template parameters for the node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplateParameters} method.
     * </p>
     * 
     * @return Template parameters for the node.
     */
    public final Map<String, String> templateParameters() {
        return templateParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags for the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return Tags for the job.
     */
    public final List<JobResourceTags> jobTags() {
        return jobTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(outputPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplateParameters() ? templateParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeFromTemplateJobRequest)) {
            return false;
        }
        CreateNodeFromTemplateJobRequest other = (CreateNodeFromTemplateJobRequest) obj;
        return Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(outputPackageName(), other.outputPackageName())
                && Objects.equals(outputPackageVersion(), other.outputPackageVersion())
                && Objects.equals(nodeName(), other.nodeName()) && Objects.equals(nodeDescription(), other.nodeDescription())
                && hasTemplateParameters() == other.hasTemplateParameters()
                && Objects.equals(templateParameters(), other.templateParameters()) && hasJobTags() == other.hasJobTags()
                && Objects.equals(jobTags(), other.jobTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNodeFromTemplateJobRequest").add("TemplateType", templateTypeAsString())
                .add("OutputPackageName", outputPackageName()).add("OutputPackageVersion", outputPackageVersion())
                .add("NodeName", nodeName()).add("NodeDescription", nodeDescription())
                .add("TemplateParameters", templateParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JobTags", hasJobTags() ? jobTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "OutputPackageName":
            return Optional.ofNullable(clazz.cast(outputPackageName()));
        case "OutputPackageVersion":
            return Optional.ofNullable(clazz.cast(outputPackageVersion()));
        case "NodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "NodeDescription":
            return Optional.ofNullable(clazz.cast(nodeDescription()));
        case "TemplateParameters":
            return Optional.ofNullable(clazz.cast(templateParameters()));
        case "JobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNodeFromTemplateJobRequest, T> g) {
        return obj -> g.apply((CreateNodeFromTemplateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNodeFromTemplateJobRequest> {
        /**
         * <p>
         * The type of node.
         * </p>
         * 
         * @param templateType
         *        The type of node.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The type of node.
         * </p>
         * 
         * @param templateType
         *        The type of node.
         * @see TemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemplateType
         */
        Builder templateType(TemplateType templateType);

        /**
         * <p>
         * An output package name for the node.
         * </p>
         * 
         * @param outputPackageName
         *        An output package name for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputPackageName(String outputPackageName);

        /**
         * <p>
         * An output package version for the node.
         * </p>
         * 
         * @param outputPackageVersion
         *        An output package version for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputPackageVersion(String outputPackageVersion);

        /**
         * <p>
         * A name for the node.
         * </p>
         * 
         * @param nodeName
         *        A name for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * A description for the node.
         * </p>
         * 
         * @param nodeDescription
         *        A description for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDescription(String nodeDescription);

        /**
         * <p>
         * Template parameters for the node.
         * </p>
         * 
         * @param templateParameters
         *        Template parameters for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateParameters(Map<String, String> templateParameters);

        /**
         * <p>
         * Tags for the job.
         * </p>
         * 
         * @param jobTags
         *        Tags for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Collection<JobResourceTags> jobTags);

        /**
         * <p>
         * Tags for the job.
         * </p>
         * 
         * @param jobTags
         *        Tags for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(JobResourceTags... jobTags);

        /**
         * <p>
         * Tags for the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobResourceTags>.Builder} avoiding the need
         * to create one manually via {@link List<JobResourceTags>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobResourceTags>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobTags(List<JobResourceTags>)}.
         * 
         * @param jobTags
         *        a consumer that will call methods on {@link List<JobResourceTags>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTags(List<JobResourceTags>)
         */
        Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String templateType;

        private String outputPackageName;

        private String outputPackageVersion;

        private String nodeName;

        private String nodeDescription;

        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNodeFromTemplateJobRequest model) {
            super(model);
            templateType(model.templateType);
            outputPackageName(model.outputPackageName);
            outputPackageVersion(model.outputPackageVersion);
            nodeName(model.nodeName);
            nodeDescription(model.nodeDescription);
            templateParameters(model.templateParameters);
            jobTags(model.jobTags);
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        @Transient
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        @Transient
        public final Builder templateType(TemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getOutputPackageName() {
            return outputPackageName;
        }

        public final void setOutputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
        }

        @Override
        @Transient
        public final Builder outputPackageName(String outputPackageName) {
            this.outputPackageName = outputPackageName;
            return this;
        }

        public final String getOutputPackageVersion() {
            return outputPackageVersion;
        }

        public final void setOutputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
        }

        @Override
        @Transient
        public final Builder outputPackageVersion(String outputPackageVersion) {
            this.outputPackageVersion = outputPackageVersion;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        @Transient
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeDescription() {
            return nodeDescription;
        }

        public final void setNodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
        }

        @Override
        @Transient
        public final Builder nodeDescription(String nodeDescription) {
            this.nodeDescription = nodeDescription;
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
        }

        @Override
        @Transient
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = TemplateParametersMapCopier.copy(templateParameters);
            return this;
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        @Transient
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(JobResourceTags... jobTags) {
            jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags) {
            jobTags(Stream.of(jobTags).map(c -> JobResourceTags.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNodeFromTemplateJobRequest build() {
            return new CreateNodeFromTemplateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
