/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter overrides for an application instance. This is a JSON document that has a single key (
 * <code>PayloadData</code>) where the value is an escaped string representation of the overrides document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManifestOverridesPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<ManifestOverridesPayload.Builder, ManifestOverridesPayload> {
    private static final SdkField<String> PAYLOAD_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadData").getter(getter(ManifestOverridesPayload::payloadData)).setter(setter(Builder::payloadData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String payloadData;

    private ManifestOverridesPayload(BuilderImpl builder) {
        this.payloadData = builder.payloadData;
    }

    /**
     * <p>
     * The overrides document.
     * </p>
     * 
     * @return The overrides document.
     */
    public final String payloadData() {
        return payloadData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestOverridesPayload)) {
            return false;
        }
        ManifestOverridesPayload other = (ManifestOverridesPayload) obj;
        return Objects.equals(payloadData(), other.payloadData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManifestOverridesPayload").add("PayloadData", payloadData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PayloadData":
            return Optional.ofNullable(clazz.cast(payloadData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManifestOverridesPayload, T> g) {
        return obj -> g.apply((ManifestOverridesPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManifestOverridesPayload> {
        /**
         * <p>
         * The overrides document.
         * </p>
         * 
         * @param payloadData
         *        The overrides document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadData(String payloadData);
    }

    static final class BuilderImpl implements Builder {
        private String payloadData;

        private BuilderImpl() {
        }

        private BuilderImpl(ManifestOverridesPayload model) {
            payloadData(model.payloadData);
        }

        public final String getPayloadData() {
            return payloadData;
        }

        public final void setPayloadData(String payloadData) {
            this.payloadData = payloadData;
        }

        @Override
        @Transient
        public final Builder payloadData(String payloadData) {
            this.payloadData = payloadData;
            return this;
        }

        @Override
        public ManifestOverridesPayload build() {
            return new ManifestOverridesPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
