/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network configuration for a device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkPayload implements SdkPojo, Serializable, ToCopyableBuilder<NetworkPayload.Builder, NetworkPayload> {
    private static final SdkField<EthernetPayload> ETHERNET0_FIELD = SdkField.<EthernetPayload> builder(MarshallingType.SDK_POJO)
            .memberName("Ethernet0").getter(getter(NetworkPayload::ethernet0)).setter(setter(Builder::ethernet0))
            .constructor(EthernetPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethernet0").build()).build();

    private static final SdkField<EthernetPayload> ETHERNET1_FIELD = SdkField.<EthernetPayload> builder(MarshallingType.SDK_POJO)
            .memberName("Ethernet1").getter(getter(NetworkPayload::ethernet1)).setter(setter(Builder::ethernet1))
            .constructor(EthernetPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethernet1").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ETHERNET0_FIELD,
            ETHERNET1_FIELD));

    private static final long serialVersionUID = 1L;

    private final EthernetPayload ethernet0;

    private final EthernetPayload ethernet1;

    private NetworkPayload(BuilderImpl builder) {
        this.ethernet0 = builder.ethernet0;
        this.ethernet1 = builder.ethernet1;
    }

    /**
     * <p>
     * Settings for Ethernet port 0.
     * </p>
     * 
     * @return Settings for Ethernet port 0.
     */
    public final EthernetPayload ethernet0() {
        return ethernet0;
    }

    /**
     * <p>
     * Settings for Ethernet port 1.
     * </p>
     * 
     * @return Settings for Ethernet port 1.
     */
    public final EthernetPayload ethernet1() {
        return ethernet1;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ethernet0());
        hashCode = 31 * hashCode + Objects.hashCode(ethernet1());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkPayload)) {
            return false;
        }
        NetworkPayload other = (NetworkPayload) obj;
        return Objects.equals(ethernet0(), other.ethernet0()) && Objects.equals(ethernet1(), other.ethernet1());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkPayload").add("Ethernet0", ethernet0()).add("Ethernet1", ethernet1()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ethernet0":
            return Optional.ofNullable(clazz.cast(ethernet0()));
        case "Ethernet1":
            return Optional.ofNullable(clazz.cast(ethernet1()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkPayload, T> g) {
        return obj -> g.apply((NetworkPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkPayload> {
        /**
         * <p>
         * Settings for Ethernet port 0.
         * </p>
         * 
         * @param ethernet0
         *        Settings for Ethernet port 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ethernet0(EthernetPayload ethernet0);

        /**
         * <p>
         * Settings for Ethernet port 0.
         * </p>
         * This is a convenience that creates an instance of the {@link EthernetPayload.Builder} avoiding the need to
         * create one manually via {@link EthernetPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link EthernetPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #ethernet0(EthernetPayload)}.
         * 
         * @param ethernet0
         *        a consumer that will call methods on {@link EthernetPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ethernet0(EthernetPayload)
         */
        default Builder ethernet0(Consumer<EthernetPayload.Builder> ethernet0) {
            return ethernet0(EthernetPayload.builder().applyMutation(ethernet0).build());
        }

        /**
         * <p>
         * Settings for Ethernet port 1.
         * </p>
         * 
         * @param ethernet1
         *        Settings for Ethernet port 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ethernet1(EthernetPayload ethernet1);

        /**
         * <p>
         * Settings for Ethernet port 1.
         * </p>
         * This is a convenience that creates an instance of the {@link EthernetPayload.Builder} avoiding the need to
         * create one manually via {@link EthernetPayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link EthernetPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #ethernet1(EthernetPayload)}.
         * 
         * @param ethernet1
         *        a consumer that will call methods on {@link EthernetPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ethernet1(EthernetPayload)
         */
        default Builder ethernet1(Consumer<EthernetPayload.Builder> ethernet1) {
            return ethernet1(EthernetPayload.builder().applyMutation(ethernet1).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EthernetPayload ethernet0;

        private EthernetPayload ethernet1;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkPayload model) {
            ethernet0(model.ethernet0);
            ethernet1(model.ethernet1);
        }

        public final EthernetPayload.Builder getEthernet0() {
            return ethernet0 != null ? ethernet0.toBuilder() : null;
        }

        public final void setEthernet0(EthernetPayload.BuilderImpl ethernet0) {
            this.ethernet0 = ethernet0 != null ? ethernet0.build() : null;
        }

        @Override
        @Transient
        public final Builder ethernet0(EthernetPayload ethernet0) {
            this.ethernet0 = ethernet0;
            return this;
        }

        public final EthernetPayload.Builder getEthernet1() {
            return ethernet1 != null ? ethernet1.toBuilder() : null;
        }

        public final void setEthernet1(EthernetPayload.BuilderImpl ethernet1) {
            this.ethernet1 = ethernet1 != null ? ethernet1.build() : null;
        }

        @Override
        @Transient
        public final Builder ethernet1(EthernetPayload ethernet1) {
            this.ethernet1 = ethernet1;
            return this;
        }

        @Override
        public NetworkPayload build() {
            return new NetworkPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
