/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A static IP configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticIpConnectionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<StaticIpConnectionInfo.Builder, StaticIpConnectionInfo> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(StaticIpConnectionInfo::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> MASK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mask")
            .getter(getter(StaticIpConnectionInfo::mask)).setter(setter(Builder::mask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mask").build()).build();

    private static final SdkField<List<String>> DNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Dns")
            .getter(getter(StaticIpConnectionInfo::dns))
            .setter(setter(Builder::dns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_GATEWAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultGateway").getter(getter(StaticIpConnectionInfo::defaultGateway))
            .setter(setter(Builder::defaultGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD, MASK_FIELD,
            DNS_FIELD, DEFAULT_GATEWAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String mask;

    private final List<String> dns;

    private final String defaultGateway;

    private StaticIpConnectionInfo(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.mask = builder.mask;
        this.dns = builder.dns;
        this.defaultGateway = builder.defaultGateway;
    }

    /**
     * <p>
     * The connection's IP address.
     * </p>
     * 
     * @return The connection's IP address.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The connection's DNS mask.
     * </p>
     * 
     * @return The connection's DNS mask.
     */
    public final String mask() {
        return mask;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dns property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasDns() {
        return dns != null && !(dns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The connection's DNS address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDns} method.
     * </p>
     * 
     * @return The connection's DNS address.
     */
    public final List<String> dns() {
        return dns;
    }

    /**
     * <p>
     * The connection's default gateway.
     * </p>
     * 
     * @return The connection's default gateway.
     */
    public final String defaultGateway() {
        return defaultGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(mask());
        hashCode = 31 * hashCode + Objects.hashCode(hasDns() ? dns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultGateway());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticIpConnectionInfo)) {
            return false;
        }
        StaticIpConnectionInfo other = (StaticIpConnectionInfo) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(mask(), other.mask())
                && hasDns() == other.hasDns() && Objects.equals(dns(), other.dns())
                && Objects.equals(defaultGateway(), other.defaultGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaticIpConnectionInfo").add("IpAddress", ipAddress()).add("Mask", mask())
                .add("Dns", hasDns() ? dns() : null).add("DefaultGateway", defaultGateway()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "Mask":
            return Optional.ofNullable(clazz.cast(mask()));
        case "Dns":
            return Optional.ofNullable(clazz.cast(dns()));
        case "DefaultGateway":
            return Optional.ofNullable(clazz.cast(defaultGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaticIpConnectionInfo, T> g) {
        return obj -> g.apply((StaticIpConnectionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticIpConnectionInfo> {
        /**
         * <p>
         * The connection's IP address.
         * </p>
         * 
         * @param ipAddress
         *        The connection's IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The connection's DNS mask.
         * </p>
         * 
         * @param mask
         *        The connection's DNS mask.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mask(String mask);

        /**
         * <p>
         * The connection's DNS address.
         * </p>
         * 
         * @param dns
         *        The connection's DNS address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dns(Collection<String> dns);

        /**
         * <p>
         * The connection's DNS address.
         * </p>
         * 
         * @param dns
         *        The connection's DNS address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dns(String... dns);

        /**
         * <p>
         * The connection's default gateway.
         * </p>
         * 
         * @param defaultGateway
         *        The connection's default gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultGateway(String defaultGateway);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String mask;

        private List<String> dns = DefaultSdkAutoConstructList.getInstance();

        private String defaultGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticIpConnectionInfo model) {
            ipAddress(model.ipAddress);
            mask(model.mask);
            dns(model.dns);
            defaultGateway(model.defaultGateway);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        @Transient
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getMask() {
            return mask;
        }

        public final void setMask(String mask) {
            this.mask = mask;
        }

        @Override
        @Transient
        public final Builder mask(String mask) {
            this.mask = mask;
            return this;
        }

        public final Collection<String> getDns() {
            if (dns instanceof SdkAutoConstructList) {
                return null;
            }
            return dns;
        }

        public final void setDns(Collection<String> dns) {
            this.dns = DnsListCopier.copy(dns);
        }

        @Override
        @Transient
        public final Builder dns(Collection<String> dns) {
            this.dns = DnsListCopier.copy(dns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dns(String... dns) {
            dns(Arrays.asList(dns));
            return this;
        }

        public final String getDefaultGateway() {
            return defaultGateway;
        }

        public final void setDefaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
        }

        @Override
        @Transient
        public final Builder defaultGateway(String defaultGateway) {
            this.defaultGateway = defaultGateway;
            return this;
        }

        @Override
        public StaticIpConnectionInfo build() {
            return new StaticIpConnectionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
