/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePackageImportJobRequest extends PanoramaRequest implements
        ToCopyableBuilder<CreatePackageImportJobRequest.Builder, CreatePackageImportJobRequest> {
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(CreatePackageImportJobRequest::jobTypeAsString))
            .setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<PackageImportJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<PackageImportJobInputConfig> builder(MarshallingType.SDK_POJO).memberName("InputConfig")
            .getter(getter(CreatePackageImportJobRequest::inputConfig)).setter(setter(Builder::inputConfig))
            .constructor(PackageImportJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<PackageImportJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<PackageImportJobOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreatePackageImportJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(PackageImportJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(CreatePackageImportJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<List<JobResourceTags>> JOB_TAGS_FIELD = SdkField
            .<List<JobResourceTags>> builder(MarshallingType.LIST)
            .memberName("JobTags")
            .getter(getter(CreatePackageImportJobRequest::jobTags))
            .setter(setter(Builder::jobTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobResourceTags> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobResourceTags::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TYPE_FIELD,
            INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, CLIENT_TOKEN_FIELD, JOB_TAGS_FIELD));

    private final String jobType;

    private final PackageImportJobInputConfig inputConfig;

    private final PackageImportJobOutputConfig outputConfig;

    private final String clientToken;

    private final List<JobResourceTags> jobTags;

    private CreatePackageImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobType = builder.jobType;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.clientToken = builder.clientToken;
        this.jobTags = builder.jobTags;
    }

    /**
     * <p>
     * A job type for the package import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link PackageImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return A job type for the package import job.
     * @see PackageImportJobType
     */
    public final PackageImportJobType jobType() {
        return PackageImportJobType.fromValue(jobType);
    }

    /**
     * <p>
     * A job type for the package import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link PackageImportJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return A job type for the package import job.
     * @see PackageImportJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * An input config for the package import job.
     * </p>
     * 
     * @return An input config for the package import job.
     */
    public final PackageImportJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * An output config for the package import job.
     * </p>
     * 
     * @return An output config for the package import job.
     */
    public final PackageImportJobOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * A client token for the package import job.
     * </p>
     * 
     * @return A client token for the package import job.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobTags() {
        return jobTags != null && !(jobTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags for the package import job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobTags} method.
     * </p>
     * 
     * @return Tags for the package import job.
     */
    public final List<JobResourceTags> jobTags() {
        return jobTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobTags() ? jobTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageImportJobRequest)) {
            return false;
        }
        CreatePackageImportJobRequest other = (CreatePackageImportJobRequest) obj;
        return Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(inputConfig(), other.inputConfig())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(clientToken(), other.clientToken())
                && hasJobTags() == other.hasJobTags() && Objects.equals(jobTags(), other.jobTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePackageImportJobRequest").add("JobType", jobTypeAsString())
                .add("InputConfig", inputConfig()).add("OutputConfig", outputConfig()).add("ClientToken", clientToken())
                .add("JobTags", hasJobTags() ? jobTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "JobTags":
            return Optional.ofNullable(clazz.cast(jobTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageImportJobRequest, T> g) {
        return obj -> g.apply((CreatePackageImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePackageImportJobRequest> {
        /**
         * <p>
         * A job type for the package import job.
         * </p>
         * 
         * @param jobType
         *        A job type for the package import job.
         * @see PackageImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageImportJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * A job type for the package import job.
         * </p>
         * 
         * @param jobType
         *        A job type for the package import job.
         * @see PackageImportJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageImportJobType
         */
        Builder jobType(PackageImportJobType jobType);

        /**
         * <p>
         * An input config for the package import job.
         * </p>
         * 
         * @param inputConfig
         *        An input config for the package import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(PackageImportJobInputConfig inputConfig);

        /**
         * <p>
         * An input config for the package import job.
         * </p>
         * This is a convenience that creates an instance of the {@link PackageImportJobInputConfig.Builder} avoiding
         * the need to create one manually via {@link PackageImportJobInputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageImportJobInputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputConfig(PackageImportJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link PackageImportJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(PackageImportJobInputConfig)
         */
        default Builder inputConfig(Consumer<PackageImportJobInputConfig.Builder> inputConfig) {
            return inputConfig(PackageImportJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * An output config for the package import job.
         * </p>
         * 
         * @param outputConfig
         *        An output config for the package import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(PackageImportJobOutputConfig outputConfig);

        /**
         * <p>
         * An output config for the package import job.
         * </p>
         * This is a convenience that creates an instance of the {@link PackageImportJobOutputConfig.Builder} avoiding
         * the need to create one manually via {@link PackageImportJobOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PackageImportJobOutputConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #outputConfig(PackageImportJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link PackageImportJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(PackageImportJobOutputConfig)
         */
        default Builder outputConfig(Consumer<PackageImportJobOutputConfig.Builder> outputConfig) {
            return outputConfig(PackageImportJobOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * A client token for the package import job.
         * </p>
         * 
         * @param clientToken
         *        A client token for the package import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Tags for the package import job.
         * </p>
         * 
         * @param jobTags
         *        Tags for the package import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(Collection<JobResourceTags> jobTags);

        /**
         * <p>
         * Tags for the package import job.
         * </p>
         * 
         * @param jobTags
         *        Tags for the package import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTags(JobResourceTags... jobTags);

        /**
         * <p>
         * Tags for the package import job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobResourceTags>.Builder} avoiding the need
         * to create one manually via {@link List<JobResourceTags>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobResourceTags>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobTags(List<JobResourceTags>)}.
         * 
         * @param jobTags
         *        a consumer that will call methods on {@link List<JobResourceTags>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobTags(List<JobResourceTags>)
         */
        Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String jobType;

        private PackageImportJobInputConfig inputConfig;

        private PackageImportJobOutputConfig outputConfig;

        private String clientToken;

        private List<JobResourceTags> jobTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageImportJobRequest model) {
            super(model);
            jobType(model.jobType);
            inputConfig(model.inputConfig);
            outputConfig(model.outputConfig);
            clientToken(model.clientToken);
            jobTags(model.jobTags);
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        @Transient
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        @Transient
        public final Builder jobType(PackageImportJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final PackageImportJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(PackageImportJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder inputConfig(PackageImportJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final PackageImportJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(PackageImportJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(PackageImportJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<JobResourceTags.Builder> getJobTags() {
            List<JobResourceTags.Builder> result = JobTagsListCopier.copyToBuilder(this.jobTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobTags(Collection<JobResourceTags.BuilderImpl> jobTags) {
            this.jobTags = JobTagsListCopier.copyFromBuilder(jobTags);
        }

        @Override
        @Transient
        public final Builder jobTags(Collection<JobResourceTags> jobTags) {
            this.jobTags = JobTagsListCopier.copy(jobTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(JobResourceTags... jobTags) {
            jobTags(Arrays.asList(jobTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobTags(Consumer<JobResourceTags.Builder>... jobTags) {
            jobTags(Stream.of(jobTags).map(c -> JobResourceTags.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePackageImportJobRequest build() {
            return new CreatePackageImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
