/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(Device::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Device::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Device::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus").getter(getter(Device::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Device::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LeaseExpirationTime").getter(getter(Device::leaseExpirationTime))
            .setter(setter(Builder::leaseExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, NAME_FIELD,
            CREATED_TIME_FIELD, PROVISIONING_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, LEASE_EXPIRATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceId;

    private final String name;

    private final Instant createdTime;

    private final String provisioningStatus;

    private final Instant lastUpdatedTime;

    private final Instant leaseExpirationTime;

    private Device(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.name = builder.name;
        this.createdTime = builder.createdTime;
        this.provisioningStatus = builder.provisioningStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.leaseExpirationTime = builder.leaseExpirationTime;
    }

    /**
     * <p>
     * The device's ID.
     * </p>
     * 
     * @return The device's ID.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The device's name.
     * </p>
     * 
     * @return The device's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * When the device was created.
     * </p>
     * 
     * @return When the device was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    /**
     * <p>
     * When the device was updated.
     * </p>
     * 
     * @return When the device was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The device's lease expiration time.
     * </p>
     * 
     * @return The device's lease expiration time.
     */
    public final Instant leaseExpirationTime() {
        return leaseExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(leaseExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(name(), other.name())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(leaseExpirationTime(), other.leaseExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Device").add("DeviceId", deviceId()).add("Name", name()).add("CreatedTime", createdTime())
                .add("ProvisioningStatus", provisioningStatusAsString()).add("LastUpdatedTime", lastUpdatedTime())
                .add("LeaseExpirationTime", leaseExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "LeaseExpirationTime":
            return Optional.ofNullable(clazz.cast(leaseExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The device's ID.
         * </p>
         * 
         * @param deviceId
         *        The device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The device's name.
         * </p>
         * 
         * @param name
         *        The device's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When the device was created.
         * </p>
         * 
         * @param createdTime
         *        When the device was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(DeviceStatus provisioningStatus);

        /**
         * <p>
         * When the device was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        When the device was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The device's lease expiration time.
         * </p>
         * 
         * @param leaseExpirationTime
         *        The device's lease expiration time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leaseExpirationTime(Instant leaseExpirationTime);
    }

    static final class BuilderImpl implements Builder {
        private String deviceId;

        private String name;

        private Instant createdTime;

        private String provisioningStatus;

        private Instant lastUpdatedTime;

        private Instant leaseExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            deviceId(model.deviceId);
            name(model.name);
            createdTime(model.createdTime);
            provisioningStatus(model.provisioningStatus);
            lastUpdatedTime(model.lastUpdatedTime);
            leaseExpirationTime(model.leaseExpirationTime);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        @Transient
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        @Transient
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
